/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.integration.bop;

import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.world.GeneratorRegistry;
import biomesoplenty.common.world.generator.tree.GeneratorBayouTree;
import biomesoplenty.common.world.generator.tree.GeneratorBigTree;
import biomesoplenty.common.world.generator.tree.GeneratorBulbTree;
import biomesoplenty.common.world.generator.tree.GeneratorMahoganyTree;
import biomesoplenty.common.world.generator.tree.GeneratorMangroveTree;
import biomesoplenty.common.world.generator.tree.GeneratorPalmTree;
import biomesoplenty.common.world.generator.tree.GeneratorTaigaTree;
import net.gegy1000.earth.server.integration.bop.PatchedBayouTreeFeature;
import net.gegy1000.earth.server.integration.bop.PatchedMangroveTreeFeature;
import net.gegy1000.earth.server.integration.bop.PatchedTaigaTreeFeature;
import net.gegy1000.earth.server.world.ecology.GrowthIndicator;
import net.gegy1000.earth.server.world.ecology.SoilPredicate;
import net.gegy1000.earth.server.world.ecology.maxent.MaxentGrowthIndicator;
import net.gegy1000.earth.server.world.ecology.vegetation.Vegetation;
import net.gegy1000.earth.server.world.ecology.vegetation.VegetationGenerator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.WorldGenerator;

public final class BoPTrees {
    public static final Vegetation MAHOGANY = Vegetation.builder().generator(VegetationGenerator.of(Generators.MAHOGANY)).growthIndicator(Indicators.MAHOGANY).build();
    public static final Vegetation PALM = Vegetation.builder().generator(VegetationGenerator.of(Generators.PALM)).growthIndicator(Indicators.PALM).build();
    public static final Vegetation EUCALYPTUS = Vegetation.builder().generator(VegetationGenerator.of(Generators.EUCALYPTUS)).growthIndicator(Indicators.EUCALYPTUS).build();
    public static final Vegetation MANGROVE = Vegetation.builder().generator(VegetationGenerator.of(Generators.MANGROVE)).growthIndicator(Indicators.MANGROVE).build();
    public static final Vegetation WILLOW = Vegetation.builder().generator((world, random, pos) -> {
        if (random.nextInt(3) == 0) {
            Generators.LARGE_WILLOW.func_180709_b(world, random, pos);
        } else {
            Generators.WILLOW.func_180709_b(world, random, pos);
        }
    }).growthIndicator(Indicators.WILLOW).build();
    public static final Vegetation EBONY = Vegetation.builder().generator(VegetationGenerator.of(Generators.EBONY)).growthIndicator(Indicators.EBONY).build();
    public static final Vegetation FIR = Vegetation.builder().generator(VegetationGenerator.of(Generators.FIR)).growthIndicator(Indicators.FIR).build();

    static class Generators {
        private static final IBlockPosQuery ANY_SOIL;
        static final WorldGenerator MAHOGANY;
        static final WorldGenerator PALM;
        static final WorldGenerator EUCALYPTUS;
        static final WorldGenerator MANGROVE;
        static final WorldGenerator WILLOW;
        static final WorldGenerator LARGE_WILLOW;
        static final WorldGenerator EBONY;
        static final WorldGenerator FIR;

        Generators() {
        }

        private static <T extends IGenerator> void registerPatchGenerator(String identifier, Class<T> generator, IGenerator.IGeneratorBuilder builder) {
            GeneratorRegistry.registerGenerator((String)identifier, generator, (IGenerator.IGeneratorBuilder)builder);
        }

        private static IBlockPosQuery soilQuery(SoilPredicate predicate) {
            return (world, pos) -> predicate.canGrowOn(world, pos, world.func_180495_p(pos));
        }

        static {
            Generators.registerPatchGenerator("patched_mangrove", PatchedMangroveTreeFeature.class, (IGenerator.IGeneratorBuilder)new PatchedMangroveTreeFeature.Builder());
            Generators.registerPatchGenerator("patched_bayou", PatchedBayouTreeFeature.class, (IGenerator.IGeneratorBuilder)new PatchedBayouTreeFeature.Builder());
            Generators.registerPatchGenerator("patched_taiga", PatchedTaigaTreeFeature.class, (IGenerator.IGeneratorBuilder)new PatchedTaigaTreeFeature.Builder());
            ANY_SOIL = Generators.soilQuery(SoilPredicate.ANY);
            MAHOGANY = ((GeneratorMahoganyTree.Builder)new GeneratorMahoganyTree.Builder().placeOn(ANY_SOIL)).create();
            PALM = new GeneratorPalmTree.Builder().create();
            EUCALYPTUS = ((GeneratorBulbTree.Builder)((GeneratorBulbTree.Builder)((GeneratorBulbTree.Builder)((GeneratorBulbTree.Builder)((GeneratorBulbTree.Builder)new GeneratorBulbTree.Builder().log(BOPWoods.EUCALYPTUS)).leaves(BOPTrees.EUCALYPTUS)).minHeight(8)).maxHeight(16)).placeOn(ANY_SOIL)).create();
            MANGROVE = ((GeneratorMangroveTree.Builder)((GeneratorMangroveTree.Builder)((GeneratorMangroveTree.Builder)new PatchedMangroveTreeFeature.Builder().log(BOPWoods.MANGROVE)).leaves(BOPTrees.MANGROVE)).placeOn(ANY_SOIL)).create();
            WILLOW = ((GeneratorBayouTree.Builder)((GeneratorBayouTree.Builder)((GeneratorBayouTree.Builder)((GeneratorBayouTree.Builder)((GeneratorBayouTree.Builder)new PatchedBayouTreeFeature.Builder().log(BOPWoods.WILLOW)).leaves(BOPTrees.WILLOW)).minHeight(6)).maxHeight(12)).minLeavesRadius(1).leavesGradient(2).placeOn(ANY_SOIL)).create();
            LARGE_WILLOW = ((GeneratorBayouTree.Builder)((GeneratorBayouTree.Builder)((GeneratorBayouTree.Builder)((GeneratorBayouTree.Builder)((GeneratorBayouTree.Builder)new PatchedBayouTreeFeature.Builder().log(BOPWoods.WILLOW)).leaves(BOPTrees.WILLOW)).minHeight(10)).maxHeight(16)).minLeavesRadius(2).leavesGradient(3).placeOn(ANY_SOIL)).create();
            EBONY = ((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().log(BOPWoods.EBONY)).leaves(BOPTrees.EBONY)).minHeight(5)).maxHeight(10)).foliageHeight(1).placeOn(ANY_SOIL)).create();
            FIR = ((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)new PatchedTaigaTreeFeature.Builder().log(BOPWoods.FIR)).leaves(BOPTrees.FIR)).minHeight(8)).maxHeight(16)).placeOn(ANY_SOIL)).create();
        }
    }

    public static class Indicators {
        public static final GrowthIndicator MAHOGANY = Indicators.maxentIndicator("mahogany").pow(1.8f);
        public static final GrowthIndicator PALM = Indicators.maxentIndicator("palm").pow(3.0f);
        public static final GrowthIndicator EUCALYPTUS = Indicators.maxentIndicator("eucalyptus").pow(3.0f);
        public static final GrowthIndicator MANGROVE = Indicators.maxentIndicator("mangrove");
        public static final GrowthIndicator WILLOW = Indicators.maxentIndicator("willow").pow(2.0f);
        public static final GrowthIndicator EBONY = Indicators.maxentIndicator("ebony").pow(1.6f);
        public static final GrowthIndicator FIR = Indicators.maxentIndicator("fir");

        private static GrowthIndicator maxentIndicator(String path) {
            return MaxentGrowthIndicator.tryParse(new ResourceLocation("earth", "vegetation/models/trees/" + path + ".lambdas")).orElse(GrowthIndicator.no());
        }
    }
}

