/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.command.debugger;

import com.google.common.base.Preconditions;
import java.awt.image.BufferedImage;
import net.gegy1000.earth.server.capability.EarthWorld;
import net.gegy1000.earth.server.command.debugger.DebugGeoProfile;
import net.gegy1000.earth.server.command.debugger.DebugProfileTestSet;
import net.gegy1000.earth.server.util.debug.BiomeColors;
import net.gegy1000.earth.server.util.debug.CoverColors;
import net.gegy1000.earth.server.util.debug.SoilColors;
import net.gegy1000.earth.server.world.EarthData;
import net.gegy1000.earth.server.world.biome.StandardBiomeClassifier;
import net.gegy1000.earth.server.world.cover.Cover;
import net.gegy1000.earth.server.world.ecology.GrowthIndicator;
import net.gegy1000.earth.server.world.ecology.GrowthPredictors;
import net.gegy1000.earth.server.world.ecology.soil.SoilSuborder;
import net.gegy1000.earth.server.world.ecology.vegetation.Vegetation;
import net.gegy1000.terrarium.server.capability.TerrariumWorld;
import net.gegy1000.terrarium.server.world.coordinate.Coordinate;
import net.gegy1000.terrarium.server.world.data.ColumnDataCache;
import net.gegy1000.terrarium.server.world.data.DataView;
import net.gegy1000.terrarium.server.world.data.raster.EnumRaster;
import net.gegy1000.terrarium.server.world.data.raster.FloatRaster;
import net.gegy1000.terrarium.server.world.data.raster.NumberRaster;
import net.gegy1000.terrarium.server.world.data.raster.Raster;
import net.gegy1000.terrarium.server.world.data.raster.ShortRaster;
import net.gegy1000.terrarium.server.world.data.raster.UByteRaster;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public final class GeoDebugger {
    private final TerrariumWorld terrarium;
    private final EarthWorld earth;

    private GeoDebugger(TerrariumWorld terrarium, EarthWorld earth) {
        this.terrarium = terrarium;
        this.earth = earth;
    }

    public static GeoDebugger from(World world) {
        TerrariumWorld terrarium = TerrariumWorld.get(world);
        Preconditions.checkNotNull((Object)terrarium, (Object)"terrarium world was null");
        EarthWorld earth = EarthWorld.get(world);
        Preconditions.checkNotNull((Object)earth, (Object)"earth world was null");
        return new GeoDebugger(terrarium, earth);
    }

    public RasterSampler vegetation(String name, Vegetation vegetation) {
        return this.heatmap(name, (dataCache, view) -> {
            GrowthIndicator indicator = vegetation.getGrowthIndicator();
            GrowthPredictors predictors = new GrowthPredictors();
            GrowthPredictors.Sampler predictorSampler = GrowthPredictors.sampler();
            UByteRaster raster = UByteRaster.create(view);
            for (int y = 0; y < view.height(); ++y) {
                for (int x = 0; x < view.width(); ++x) {
                    int blockX = view.minX() + x;
                    int blockZ = view.minY() + y;
                    predictorSampler.sampleTo(dataCache, blockX, blockZ, predictors);
                    if (!((double)predictors.elevation >= 0.0)) continue;
                    double suitabilityIndex = indicator.evaluate(predictors);
                    raster.set(x, y, MathHelper.func_76128_c((double)(suitabilityIndex * 255.0)));
                }
            }
            return raster;
        });
    }

    public <R extends NumberRaster<?>> RasterSampler scaledHeatmap(String name, Raster.Sampler<R> sampler) {
        return this.heatmap(name, (dataCache, view) -> {
            NumberRaster source = (NumberRaster)sampler.sample(dataCache, view);
            double min = source.stream().min().orElse(0.0);
            double max = source.stream().max().orElse(0.0);
            UByteRaster result = UByteRaster.create(view);
            for (int y = 0; y < view.height(); ++y) {
                for (int x = 0; x < view.width(); ++x) {
                    double value = source.getFloat(x, y);
                    result.set(x, y, MathHelper.func_76128_c((double)((value - min) / (max - min) * 255.0)));
                }
            }
            return result;
        });
    }

    public RasterSampler heatmap(String name, Raster.Sampler<UByteRaster> sampler) {
        return new RasterSampler(name, (dataCache, view) -> {
            BufferedImage image = new BufferedImage(view.width(), view.height(), 1);
            UByteRaster raster = (UByteRaster)sampler.apply(dataCache, view);
            raster.iterate((value, x, y) -> image.setRGB(x, y, 0xFF0000 | value << 8));
            return image;
        });
    }

    public RasterSampler cover(String name, EnumRaster.Sampler<Cover> sampler) {
        return new RasterSampler(name, (dataCache, view) -> {
            BufferedImage image = new BufferedImage(view.width(), view.height(), 1);
            Object raster = sampler.sample(dataCache, view);
            ((EnumRaster)raster).iterate((cover, x, y) -> image.setRGB(x, y, CoverColors.get(cover)));
            return image;
        });
    }

    public RasterSampler soilSuborder(String name, EnumRaster.Sampler<SoilSuborder> sampler) {
        return new RasterSampler(name, (dataCache, view) -> {
            BufferedImage image = new BufferedImage(view.width(), view.height(), 1);
            Object raster = sampler.sample(dataCache, view);
            ((EnumRaster)raster).iterate((cover, x, y) -> image.setRGB(x, y, SoilColors.get(cover)));
            return image;
        });
    }

    public RasterSampler biomes(String name, GrowthPredictors.Sampler sampler) {
        return new RasterSampler(name, (dataCache, view) -> {
            BufferedImage image = new BufferedImage(view.width(), view.height(), 1);
            StandardBiomeClassifier classifier = new StandardBiomeClassifier();
            GrowthPredictors predictors = new GrowthPredictors();
            for (int y = 0; y < view.height(); ++y) {
                for (int x = 0; x < view.width(); ++x) {
                    sampler.sampleTo(dataCache, x + view.minX(), y + view.minY(), predictors);
                    Biome biome = classifier.classify(predictors);
                    image.setRGB(x, y, BiomeColors.get(biome));
                }
            }
            return image;
        });
    }

    public DebugGeoProfile[] takeTestProfiles() {
        DebugProfileTestSet.Location[] testSet = DebugProfileTestSet.get();
        DebugGeoProfile[] profiles = new DebugGeoProfile[testSet.length];
        for (int i = 0; i < testSet.length; ++i) {
            DebugProfileTestSet.Location location = testSet[i];
            Coordinate coordinate = new Coordinate(this.earth.getCrs(), location.longitude, location.latitude);
            profiles[i] = this.takeProfile(location.name, coordinate.blockX(), coordinate.blockZ());
        }
        return profiles;
    }

    public DebugGeoProfile takeProfile(String name, double x, double z) {
        ColumnDataCache data = this.terrarium.getDataCache();
        Coordinate coordinate = Coordinate.atBlock(x, z).to(this.earth.getCrs());
        double latitude = coordinate.z();
        double longitude = coordinate.x();
        int bx = MathHelper.func_76128_c((double)x);
        int bz = MathHelper.func_76128_c((double)z);
        float elevation = FloatRaster.sampler(EarthData.ELEVATION_METERS).sample(data, bx, bz);
        Cover cover = EnumRaster.sampler(EarthData.COVER, Cover.NO).sample(data, bx, bz);
        float meanTemperature = FloatRaster.sampler(EarthData.MEAN_TEMPERATURE).sample(data, bx, bz);
        float minTemperature = FloatRaster.sampler(EarthData.MIN_TEMPERATURE).sample(data, bx, bz);
        short annualRainfall = ShortRaster.sampler(EarthData.ANNUAL_RAINFALL).sample(data, bx, bz);
        SoilSuborder soilSuborder = EnumRaster.sampler(EarthData.SOIL_SUBORDER, SoilSuborder.NO).sample(data, bx, bz);
        int siltContent = UByteRaster.sampler(EarthData.SILT_CONTENT).sample(data, bx, bz);
        int sandContent = UByteRaster.sampler(EarthData.SAND_CONTENT).sample(data, bx, bz);
        int clayContent = UByteRaster.sampler(EarthData.CLAY_CONTENT).sample(data, bx, bz);
        short organicCarbonContent = ShortRaster.sampler(EarthData.ORGANIC_CARBON_CONTENT).sample(data, bx, bz);
        int cationExchangeCapacity = UByteRaster.sampler(EarthData.CATION_EXCHANGE_CAPACITY).sample(data, bx, bz);
        int soilPh = UByteRaster.sampler(EarthData.SOIL_PH).sample(data, bx, bz);
        return new DebugGeoProfile(name, latitude, longitude, elevation, cover, meanTemperature, minTemperature, annualRainfall, soilSuborder, siltContent, sandContent, clayContent, organicCarbonContent, cationExchangeCapacity, (float)soilPh / 10.0f);
    }

    public static class RasterSampler {
        public final String name;
        private final Raster.Sampler<BufferedImage> function;

        public RasterSampler(String name, Raster.Sampler<BufferedImage> sampler) {
            this.name = name;
            this.function = sampler;
        }

        public BufferedImage sample(ColumnDataCache data, DataView view) {
            return this.function.apply(data, view);
        }
    }
}

