/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.command;

import java.util.ArrayList;
import java.util.List;
import net.gegy1000.earth.server.command.ContainerUiInventory;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class ContainerUi {
    public static final int WIDTH = 9;
    public static final int PADDING = 1;
    public static final int PADDED_WIDTH = 7;
    private final EntityPlayerMP player;
    private final ITextComponent title;
    private final Element[] elements;
    private final int rows;

    private ContainerUi(EntityPlayerMP player, ITextComponent title, Element[] elements) {
        this.player = player;
        this.title = title;
        this.elements = elements;
        this.rows = MathHelper.func_76143_f((double)((double)elements.length / 7.0));
        this.resolveRows();
    }

    public static Builder builder(EntityPlayerMP player) {
        return new Builder(player);
    }

    private void resolveRows() {
        for (int row = 0; row < this.rows; ++row) {
            Element[] resolved = this.resolveRow(row);
            int minColumn = (9 - resolved.length) / 2;
            for (int column = 0; column < resolved.length; ++column) {
                resolved[column].setPosition(row, column + minColumn);
            }
        }
    }

    private Element[] resolveRow(int row) {
        int minId = Integer.MAX_VALUE;
        int maxId = Integer.MIN_VALUE;
        int rowStart = row * 7;
        int rowEnd = Math.min(rowStart + 7, this.elements.length);
        for (int id = rowStart; id < rowEnd; ++id) {
            if (this.elements[id] == null) continue;
            if (id < minId) {
                minId = id;
            }
            if (id <= maxId) continue;
            maxId = id;
        }
        Element[] resolved = new Element[maxId - minId + 1];
        System.arraycopy(this.elements, minId, resolved, 0, resolved.length);
        return resolved;
    }

    public ContainerUiInventory createInventory() {
        return new ContainerUiInventory(this.player, this.title, this.elements, this.rows);
    }

    public static class Element {
        private final int id;
        private final Item icon;
        private final String name;
        private final Runnable clickHandler;
        private int row;
        private int column;

        private Element(int id, Item icon, String name, Runnable clickHandler) {
            this.id = id;
            this.icon = icon;
            this.name = name;
            this.clickHandler = clickHandler;
        }

        public void setPosition(int row, int column) {
            this.row = row;
            this.column = column;
        }

        public int getId() {
            return this.id;
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }

        public ItemStack createStack() {
            ItemStack stack = new ItemStack(this.icon, 1);
            stack.func_151001_c(this.name);
            return stack;
        }

        public void handleClick() {
            this.clickHandler.run();
        }
    }

    public static class Builder {
        private final EntityPlayerMP player;
        private final List<Element> elements = new ArrayList<Element>();
        private ITextComponent title = new TextComponentString("Container");

        private Builder(EntityPlayerMP player) {
            this.player = player;
        }

        public Builder addElement(Item icon, String name, Runnable clickHandler) {
            Element element = new Element(this.elements.size(), icon, name, clickHandler);
            this.elements.add(element);
            return this;
        }

        public Builder addElement(Block icon, String name, Runnable clickHandler) {
            return this.addElement(Item.func_150898_a((Block)icon), name, clickHandler);
        }

        public Builder setTitle(ITextComponent title) {
            this.title = title;
            return this;
        }

        public ContainerUi build() {
            return new ContainerUi(this.player, this.title, this.elements.toArray(new Element[0]));
        }
    }
}

