/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client.terrain;

import com.google.common.collect.Sets;
import java.awt.Color;
import java.util.Set;
import javax.vecmath.Vector3f;
import net.gegy1000.earth.client.terrain.TerrainColorizer;
import net.gegy1000.earth.client.terrain.TerrainMesh;
import net.gegy1000.earth.server.world.EarthData;
import net.gegy1000.earth.server.world.cover.Cover;
import net.gegy1000.terrarium.client.render.TerrariumVertexFormats;
import net.gegy1000.terrarium.server.world.data.DataKey;
import net.gegy1000.terrarium.server.world.data.DataSample;
import net.gegy1000.terrarium.server.world.data.DataView;
import net.gegy1000.terrarium.server.world.data.raster.EnumRaster;
import net.gegy1000.terrarium.server.world.data.raster.FloatRaster;
import net.gegy1000.terrarium.server.world.data.raster.ShortRaster;
import net.gegy1000.terrarium.server.world.data.raster.UByteRaster;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.math.Vec3d;

public final class TerrainMeshData {
    public static final Set<DataKey<?>> REQUIRED_DATA = Sets.newHashSet((Object[])new DataKey[]{EarthData.TERRAIN_HEIGHT, EarthData.SLOPE, EarthData.MIN_TEMPERATURE, EarthData.COVER});
    private static final Vector3f NORMAL_STORE = new Vector3f();
    private final BufferBuilder buffer;

    private TerrainMeshData(BufferBuilder buffer) {
        this.buffer = buffer;
    }

    public TerrainMesh upload() {
        return TerrainMesh.upload(this.buffer);
    }

    public static TerrainMeshData build(DataSample data, int granularity, Vec3d translation) {
        BufferBuilder builder = new BufferBuilder(TerrainMeshData.computeBufferSize(data.getView(), granularity));
        builder.func_181668_a(7, TerrariumVertexFormats.POSITION_COLOR_NORMAL);
        ShortRaster heightRaster = data.getOrDefault(EarthData.TERRAIN_HEIGHT);
        UByteRaster slopeRaster = data.getOrDefault(EarthData.SLOPE);
        FloatRaster minTemperatureRaster = data.getOrDefault(EarthData.MIN_TEMPERATURE);
        EnumRaster<Cover> coverRaster = data.getOrDefault(EarthData.COVER);
        int width = heightRaster.width();
        int height = heightRaster.height();
        short[] heightBuffer = (short[])heightRaster.asRawData();
        int strideX = granularity;
        int strideY = width * granularity;
        builder.func_178969_c(translation.field_72450_a, translation.field_72448_b, translation.field_72449_c);
        for (int localZ = 0; localZ < height - granularity; localZ += granularity) {
            for (int localX = 0; localX < width - granularity; localX += granularity) {
                int index = localX + localZ * width;
                short topLeft = heightBuffer[index];
                short topRight = heightBuffer[index + strideX];
                short bottomLeft = heightBuffer[index + strideY];
                short bottomRight = heightBuffer[index + strideX + strideY];
                Cover cover = coverRaster.get(localX, localZ);
                int slope = slopeRaster.get(localX, localZ);
                float minTemperature = minTemperatureRaster.get(localX, localZ);
                Color color = TerrainColorizer.get(cover, slope, minTemperature);
                int red = color.getRed();
                int green = color.getGreen();
                int blue = color.getBlue();
                Vector3f normal = TerrainMeshData.computeNormal(topLeft, topRight, bottomLeft);
                float nx = normal.x;
                float ny = normal.y;
                float nz = normal.z;
                builder.func_181662_b((double)localX, (double)bottomLeft, (double)(localZ + granularity)).func_181669_b(red, green, blue, 255).func_181663_c(nx, ny, nz).func_181675_d();
                builder.func_181662_b((double)(localX + granularity), (double)bottomRight, (double)(localZ + granularity)).func_181669_b(red, green, blue, 255).func_181663_c(nx, ny, nz).func_181675_d();
                builder.func_181662_b((double)(localX + granularity), (double)topRight, (double)localZ).func_181669_b(red, green, blue, 255).func_181663_c(nx, ny, nz).func_181675_d();
                builder.func_181662_b((double)localX, (double)topLeft, (double)localZ).func_181669_b(red, green, blue, 255).func_181663_c(nx, ny, nz).func_181675_d();
            }
        }
        builder.func_178977_d();
        return new TerrainMeshData(builder);
    }

    private static int computeBufferSize(DataView view, int granularity) {
        int vertexWidth = TerrariumVertexFormats.POSITION_COLOR_NORMAL.func_177338_f();
        int quadCountX = (view.width() - granularity) / granularity;
        int quadCountZ = (view.height() - granularity) / granularity;
        int vertexCount = quadCountX * quadCountZ * 4;
        return vertexCount * vertexWidth;
    }

    private static Vector3f computeNormal(int topLeft, int topRight, int bottomLeft) {
        NORMAL_STORE.set((float)(topLeft - topRight), 1.0f, (float)(topLeft - bottomLeft));
        NORMAL_STORE.normalize();
        return NORMAL_STORE;
    }
}

