/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client.gui.widget.map;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.vecmath.Vector2d;
import net.gegy1000.terrarium.Terrarium;
import net.gegy1000.terrarium.server.world.data.source.Geocoder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;

public class PlaceSearchWidget
extends GuiTextField {
    private static final int SUGGESTION_COUNT = 3;
    private static final int SUGGESTION_HEIGHT = 20;
    private static final long MIN_SUGGEST_INTERVAL_MS = 500L;
    private final Geocoder geocoder;
    private final SearchHandler searchHandler;
    private final ExecutorService executor = Executors.newFixedThreadPool(1);
    private final List<String> suggestions = new ArrayList<String>(3);
    private Future<String[]> queriedSuggestions;
    private State state = State.OK;
    private boolean pause;
    private String lastSearchText;
    private long lastSearchTextTime;

    public PlaceSearchWidget(int id, int x, int y, int width, int height, Geocoder geocoder, SearchHandler searchHandler) {
        super(id, Minecraft.func_71410_x().field_71466_p, x, y, width, height);
        this.geocoder = geocoder;
        this.searchHandler = searchHandler;
    }

    public void update() {
        super.func_146178_a();
        if (this.queriedSuggestions != null && this.queriedSuggestions.isDone()) {
            this.suggestions.clear();
            try {
                String[] result = this.queriedSuggestions.get();
                if (result != null) {
                    this.suggestions.addAll(Arrays.asList(result).subList(0, Math.min(result.length, 3)));
                    if (this.suggestions.isEmpty()) {
                        this.state = State.NOT_FOUND;
                    }
                } else {
                    this.state = State.OK;
                }
                this.queriedSuggestions = null;
            }
            catch (InterruptedException | ExecutionException e) {
                Terrarium.LOGGER.error("Failed to get queried suggestions", (Throwable)e);
            }
        }
        String text = this.func_146179_b().trim();
        if (!this.pause && !text.isEmpty()) {
            long time;
            if (!text.equals(this.lastSearchText) && this.queriedSuggestions == null && (time = System.currentTimeMillis()) - this.lastSearchTextTime > 500L) {
                this.suggestions.clear();
                try {
                    this.queriedSuggestions = this.executor.submit(() -> this.geocoder.suggest(text));
                }
                catch (Exception e) {
                    Terrarium.LOGGER.error("Failed to get geocoder suggestions", (Throwable)e);
                }
                this.lastSearchText = text;
                this.lastSearchTextTime = time;
            }
        } else {
            this.suggestions.clear();
        }
    }

    public boolean func_146181_i() {
        return false;
    }

    public int func_146200_o() {
        return this.field_146218_h - 8;
    }

    public void draw(int mouseX, int mouseY) {
        if (this.func_146176_q()) {
            PlaceSearchWidget.func_73734_a((int)(this.field_146209_f - 1), (int)(this.field_146210_g - 1), (int)(this.field_146209_f + this.field_146218_h + 1), (int)(this.field_146210_g + this.field_146219_i + 1), (int)-6250336);
            PlaceSearchWidget.func_73734_a((int)this.field_146209_f, (int)this.field_146210_g, (int)(this.field_146209_f + this.field_146218_h), (int)(this.field_146210_g + this.field_146219_i), (int)this.state.getBackgroundColor());
            super.func_146194_f();
            if (!this.suggestions.isEmpty() && this.func_146206_l()) {
                FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                int suggestionBoxHeight = 20 * this.suggestions.size() + 2;
                int suggestionOriginY = this.field_146210_g + this.field_146219_i;
                PlaceSearchWidget.func_73734_a((int)(this.field_146209_f - 1), (int)suggestionOriginY, (int)(this.field_146209_f + this.field_146218_h + 1), (int)(suggestionOriginY + suggestionBoxHeight), (int)-6250336);
                for (int i = 0; i < this.suggestions.size(); ++i) {
                    String suggestion = fontRenderer.func_78269_a(this.suggestions.get(i), this.field_146218_h - 8);
                    int suggestionX = this.field_146209_f;
                    int suggestionY = suggestionOriginY + i * 20 + 1;
                    if (mouseX >= suggestionX && mouseY >= suggestionY && mouseX <= suggestionX + this.field_146218_h && mouseY <= suggestionY + 20) {
                        PlaceSearchWidget.func_73734_a((int)suggestionX, (int)suggestionY, (int)(suggestionX + this.field_146218_h), (int)(suggestionY + 20), (int)-11503456);
                    }
                    fontRenderer.func_175063_a(suggestion, (float)(suggestionX + 4), (float)suggestionY + (float)(20 - fontRenderer.field_78288_b) / 2.0f, -1);
                }
            }
        }
    }

    public boolean func_146192_a(int mouseX, int mouseY, int mouseButton) {
        if (this.func_146176_q() && this.func_146206_l() && !this.suggestions.isEmpty()) {
            int suggestionOriginY = this.field_146210_g + this.field_146219_i;
            for (int i = 0; i < this.suggestions.size(); ++i) {
                int suggestionX = this.field_146209_f;
                int suggestionY = suggestionOriginY + i * 20 + 1;
                if (mouseX < suggestionX || mouseY < suggestionY || mouseX > suggestionX + this.field_146218_h || mouseY > suggestionY + 20) continue;
                this.func_146180_a(this.suggestions.get(i));
                this.state = State.FOUND;
                this.handleAccept();
                return true;
            }
        }
        return super.func_146192_a(mouseX, mouseY, mouseButton);
    }

    public boolean func_146201_a(char typedChar, int keyCode) {
        if (!this.func_146206_l()) {
            return false;
        }
        this.pause = false;
        if (keyCode == 28) {
            this.handleAccept();
            this.suggestions.clear();
            return true;
        }
        if (super.func_146201_a(typedChar, keyCode)) {
            this.state = State.OK;
        }
        return false;
    }

    public void onGuiClosed() {
        this.executor.shutdownNow();
    }

    private void handleAccept() {
        String text = this.func_146179_b();
        try {
            Vector2d coordinate = this.geocoder.get(text);
            if (coordinate != null) {
                this.searchHandler.handle(coordinate.getX(), coordinate.getY());
                this.state = State.FOUND;
            } else {
                this.state = State.NOT_FOUND;
            }
            this.pause = true;
        }
        catch (IOException e) {
            Terrarium.LOGGER.error("Failed to find searched place {}", (Object)text, (Object)e);
        }
    }

    public static enum State {
        OK(-16777216),
        FOUND(-16759296),
        NOT_FOUND(-12189696);

        private final int backgroundColor;

        private State(int backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        public int getBackgroundColor() {
            return this.backgroundColor;
        }
    }

    public static interface SearchHandler {
        public void handle(double var1, double var3);
    }
}

