/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client.gui.preview;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.gegy1000.earth.client.terrain.TerrainMeshData;
import net.gegy1000.earth.server.world.EarthData;
import net.gegy1000.earth.server.world.EarthInitContext;
import net.gegy1000.earth.server.world.EarthProperties;
import net.gegy1000.justnow.future.Future;
import net.gegy1000.terrarium.server.world.TerrariumDataInitializer;
import net.gegy1000.terrarium.server.world.TerrariumWorldType;
import net.gegy1000.terrarium.server.world.coordinate.Coordinate;
import net.gegy1000.terrarium.server.world.data.DataGenerator;
import net.gegy1000.terrarium.server.world.data.DataSample;
import net.gegy1000.terrarium.server.world.data.DataView;
import net.gegy1000.terrarium.server.world.data.raster.ShortRaster;
import net.gegy1000.terrarium.server.world.generator.customization.GenerationSettings;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public final class PreviewMeshBuilder {
    private static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("terrarium-preview-build").build());

    public static Future<TerrainMeshData> build(TerrariumWorldType worldType, GenerationSettings settings) {
        TerrariumDataInitializer dataInitializer = worldType.createDataInitializer(settings);
        EarthInitContext ctx = EarthInitContext.from(settings);
        DataGenerator.Builder dataGenerator = DataGenerator.builder();
        dataInitializer.setup(dataGenerator);
        double latitude = settings.getDouble(EarthProperties.SPAWN_LATITUDE);
        double longitude = settings.getDouble(EarthProperties.SPAWN_LONGITUDE);
        Coordinate spawnCoordinate = ctx.lngLatCrs.coord(longitude, latitude);
        BlockPos topLeft = ctx.lngLatCrs.coord(-180.0, 90.0).toBlockPos().func_177971_a((Vec3i)new BlockPos(4, 0, 4));
        BlockPos bottomRight = ctx.lngLatCrs.coord(180.0, -90.0).toBlockPos().func_177973_b((Vec3i)new BlockPos(4, 0, 4));
        return PreviewMeshBuilder.build(dataGenerator.build(), spawnCoordinate.toBlockPos(), topLeft, bottomRight);
    }

    private static Future<TerrainMeshData> build(DataGenerator dataGenerator, BlockPos spawnPos, BlockPos minCorner, BlockPos maxCorner) {
        int minX = Math.max(spawnPos.func_177958_n() - 256, minCorner.func_177958_n());
        int minZ = Math.max(spawnPos.func_177952_p() - 256, minCorner.func_177952_p());
        int maxX = Math.min(spawnPos.func_177958_n() + 256, maxCorner.func_177958_n());
        int maxZ = Math.min(spawnPos.func_177952_p() + 256, maxCorner.func_177952_p());
        int width = maxX - minX + 1;
        int height = maxZ - minZ + 1;
        return PreviewMeshBuilder.sampleData(dataGenerator, minX, minZ, width, height).andThen(data -> Future.spawnBlocking(EXECUTOR, () -> PreviewMeshBuilder.buildMesh(data)));
    }

    private static TerrainMeshData buildMesh(DataSample data) {
        ShortRaster heightRaster = data.getOrDefault(EarthData.TERRAIN_HEIGHT);
        Vec3d translation = new Vec3d((double)(-heightRaster.width()) / 2.0, (double)(-PreviewMeshBuilder.computeOriginHeight(heightRaster)), (double)(-heightRaster.height()) / 2.0);
        return TerrainMeshData.build(data, 2, translation);
    }

    private static Future<DataSample> sampleData(DataGenerator dataGenerator, int x, int z, int width, int height) {
        DataView view = DataView.of(x, z, width, height);
        return dataGenerator.generate(view, TerrainMeshData.REQUIRED_DATA);
    }

    private static short computeOriginHeight(ShortRaster heightRaster) {
        short[] shortData;
        long total = 0L;
        long maxHeight = 0L;
        for (short value : shortData = (short[])heightRaster.asRawData()) {
            if ((long)value > maxHeight) {
                maxHeight = value;
            }
            total += (long)value;
        }
        long averageHeight = total / (long)shortData.length;
        return (short)((averageHeight + maxHeight + maxHeight) / 3L);
    }
}

