/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client.gui;

import net.gegy1000.earth.TerrariumEarth;
import net.gegy1000.earth.server.shared.SharedDataInitializers;
import net.gegy1000.earth.server.shared.SharedEarthData;
import net.gegy1000.earth.server.util.ProcessTracker;
import net.gegy1000.earth.server.util.ProgressTracker;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SharedInitializingGui
extends GuiScreen {
    private static final int RETRY_BUTTON = 0;
    private static final int CANCEL_BUTTON = 1;
    private static final int BAR_HEIGHT = 14;
    private static final int BAR_BACKGROUND_COLOR = -16777216;
    private static final int BAR_WORKING_COLOR = -13408734;
    private static final int BAR_ERRORED_COLOR = -10083806;
    private final GuiScreen parent;
    private final Runnable onComplete;
    private ProcessTracker process;
    private boolean errored;
    private int completeTicks;

    public SharedInitializingGui(GuiScreen parent, Runnable onComplete) {
        this.parent = parent;
        this.onComplete = onComplete;
        this.startProcess();
    }

    private void startProcess() {
        this.completeTicks = 0;
        this.errored = false;
        this.process = new ProcessTracker();
        SharedDataInitializers.initialize(this.process).thenApply(data -> {
            SharedEarthData.supply(data);
            return data;
        });
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        if (this.errored) {
            this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 - 154, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.earth.retry", (Object[])new Object[0])));
            this.func_189646_b(new GuiButton(1, this.field_146294_l / 2 + 4, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (!button.field_146124_l) {
            return;
        }
        switch (button.field_146127_k) {
            case 0: {
                this.startProcess();
                this.func_73866_w_();
                break;
            }
            case 1: {
                this.field_146297_k.func_147108_a(this.parent);
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a(this.parent);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.process.isComplete()) {
            if (this.completeTicks++ > 10) {
                this.onComplete.run();
            }
        } else if (this.process.isErrored() && !this.errored) {
            this.errored = true;
            TerrariumEarth.LOGGER.warn("Failed to prepare Terrarium for use", (Throwable)this.process.getException());
            this.func_73866_w_();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        String[] description;
        String title;
        this.func_146276_q_();
        int centerX = this.field_146294_l / 2;
        int centerY = this.field_146295_m / 2;
        if (!this.process.isErrored()) {
            title = I18n.func_135052_a((String)"gui.earth.preparing", (Object[])new Object[0]);
            description = new String[]{I18n.func_135052_a((String)"gui.earth.preparing.desc.1", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.earth.preparing.desc.2", (Object[])new Object[0])};
        } else {
            title = I18n.func_135052_a((String)"gui.earth.preparing.errored", (Object[])new Object[0]);
            description = new String[]{I18n.func_135052_a((String)"gui.earth.preparing.errored.desc.1", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.earth.preparing.errored.desc.2", (Object[])new Object[0])};
        }
        this.func_73732_a(this.field_146289_q, title, centerX, 20, 0xFFFFFF);
        int descriptionY = 50;
        int descriptionLineSpacing = this.field_146289_q.field_78288_b + 2;
        for (int index2 = 0; index2 < description.length; ++index2) {
            String line = description[index2];
            int lineY = descriptionY + index2 * descriptionLineSpacing;
            this.func_73732_a(this.field_146289_q, line, centerX, lineY, 0xA0A0A0);
        }
        this.process.forEach((tracker, index) -> this.drawProgressBar(tracker, centerY + index * 34));
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void drawProgressBar(ProgressTracker tracker, int y) {
        double progress = tracker.getProgress();
        String description = tracker.getDescription().func_150254_d();
        int barWidth = MathHelper.func_76143_f((double)((double)this.field_146294_l * 0.75));
        int minX = (this.field_146294_l - barWidth) / 2;
        int minY = y - 7;
        int maxX = (this.field_146294_l + barWidth) / 2;
        int maxY = y + 7;
        Gui.func_73734_a((int)minX, (int)minY, (int)maxX, (int)maxY, (int)-16777216);
        if (progress > 0.0) {
            int color = tracker.isErrored() ? -10083806 : -13408734;
            int progressX = MathHelper.func_76128_c((double)((double)minX + (double)(maxX - minX) * progress));
            Gui.func_73734_a((int)(minX + 1), (int)(minY + 1), (int)(progressX - 1), (int)(maxY - 1), (int)color);
        }
        int centerX = (minX + maxX) / 2;
        int titleY = minY - this.field_146289_q.field_78288_b - 2;
        int centerY = (minY + maxY - this.field_146289_q.field_78288_b) / 2 + 1;
        String percentageString = String.format("%.0f%%", progress * 100.0);
        this.func_73732_a(this.field_146289_q, percentageString, centerX, centerY, 0xA0A0A0);
        this.func_73732_a(this.field_146289_q, description, centerX, titleY, 0xA0A0A0);
    }
}

