/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client.gui;

import java.io.IOException;
import net.gegy1000.earth.TerrariumEarth;
import net.gegy1000.earth.client.gui.widget.map.PlaceSearchWidget;
import net.gegy1000.earth.client.gui.widget.map.SlippyMapPoint;
import net.gegy1000.earth.client.gui.widget.map.SlippyMapWidget;
import net.gegy1000.earth.client.gui.widget.map.component.MarkerMapComponent;
import net.gegy1000.terrarium.client.gui.widget.CopyBoxWidget;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Keyboard;

public class EarthLocateGui
extends GuiScreen {
    private static final int TELEPORT_BUTTON = 0;
    private static final int CANCEL_BUTTON = 1;
    private static final int SEARCH_FIELD = 2;
    private final double latitude;
    private final double longitude;
    private SlippyMapWidget mapWidget;
    private MarkerMapComponent markerComponent;
    private PlaceSearchWidget searchWidget;
    private CopyBoxWidget locationBox;

    public EarthLocateGui(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public void func_73866_w_() {
        if (this.mapWidget != null) {
            this.mapWidget.close();
        }
        this.field_146292_n.clear();
        this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 - 155, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.button.earth.teleport", (Object[])new Object[0])));
        this.func_189646_b(new GuiButton(1, this.field_146294_l / 2 + 5, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.mapWidget = new SlippyMapWidget(60, 20, this.field_146294_l - 120, this.field_146295_m - 100);
        this.mapWidget.getMap().focus(this.latitude, this.longitude, 11);
        this.markerComponent = new MarkerMapComponent(new SlippyMapPoint(this.latitude, this.longitude)).allowMovement();
        this.markerComponent.setOffsetX(16.0f);
        this.markerComponent.setOffsetY(32.0f);
        this.mapWidget.addComponent(this.markerComponent);
        this.mapWidget.addComponent(new MarkerMapComponent(new SlippyMapPoint(this.latitude, this.longitude)));
        int copyBoxWidth = 240;
        String locationText = String.format("%.5f, %.5f", this.latitude, this.longitude);
        this.locationBox = new CopyBoxWidget((this.field_146294_l - copyBoxWidth) / 2, this.field_146295_m - 75, copyBoxWidth, 20, locationText, this.field_146289_q);
        this.searchWidget = new PlaceSearchWidget(2, 65, 25, 180, 20, TerrariumEarth.getPreferredGeocoder(), this::handleSearch);
    }

    private void handleSearch(double latitude, double longitude) {
        this.markerComponent.moveMarker(latitude, longitude);
        this.mapWidget.getMap().focus(latitude, longitude, 12);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146125_m) {
            switch (button.field_146127_k) {
                case 0: {
                    SlippyMapPoint marker = this.markerComponent.getMarker();
                    this.func_175275_f(String.format("/geotp %s %s", marker.getLatitude(), marker.getLongitude()));
                    this.field_146297_k.func_147108_a(null);
                    break;
                }
                case 1: {
                    this.field_146297_k.func_147108_a(null);
                }
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.mapWidget.draw(mouseX, mouseY, partialTicks);
        this.searchWidget.draw(mouseX, mouseY);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.earth.locate", (Object[])new Object[0]), this.field_146294_l / 2, 4, 0xFFFFFF);
        this.locationBox.draw(mouseX, mouseY);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.searchWidget.update();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.searchWidget.func_146206_l() && this.searchWidget.func_146201_a(typedChar, keyCode)) {
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.searchWidget.func_146192_a(mouseX, mouseY, mouseButton)) {
            return;
        }
        this.mapWidget.mouseClicked(mouseX, mouseY, mouseButton);
        this.locationBox.mouseClicked(mouseX, mouseY);
    }

    protected void func_146273_a(int mouseX, int mouseY, int mouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, mouseButton, timeSinceLastClick);
        this.mapWidget.mouseDragged(mouseX, mouseY, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        super.func_146286_b(mouseX, mouseY, mouseButton);
        this.mapWidget.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.mapWidget.close();
        this.searchWidget.onGuiClosed();
        Keyboard.enableRepeatEvents((boolean)false);
    }
}

