/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client.gui;

import com.google.common.base.Strings;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import net.gegy1000.earth.client.gui.SelectEarthSpawnpointGui;
import net.gegy1000.earth.client.gui.preview.LargePreviewGui;
import net.gegy1000.earth.client.gui.preview.PreviewController;
import net.gegy1000.earth.client.gui.preview.PreviewRenderer;
import net.gegy1000.earth.client.gui.preview.WorldPreview;
import net.gegy1000.earth.server.world.EarthProperties;
import net.gegy1000.terrarium.Terrarium;
import net.gegy1000.terrarium.client.gui.customization.SelectPresetGui;
import net.gegy1000.terrarium.client.gui.widget.ActionButtonWidget;
import net.gegy1000.terrarium.client.gui.widget.CustomizationList;
import net.gegy1000.terrarium.server.world.TerrariumWorldType;
import net.gegy1000.terrarium.server.world.generator.customization.GenerationSettings;
import net.gegy1000.terrarium.server.world.generator.customization.PropertySchema;
import net.gegy1000.terrarium.server.world.generator.customization.TerrariumPreset;
import net.gegy1000.terrarium.server.world.generator.customization.widget.CustomizationCategory;
import net.gegy1000.terrarium.server.world.generator.customization.widget.CustomizationWidget;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;

public class EarthCustomizationGui
extends GuiScreen {
    private static final long PREVIEW_UPDATE_INTERVAL = 200L;
    private static final int DONE_BUTTON = 0;
    private static final int CANCEL_BUTTON = 1;
    private static final int PRESET_BUTTON = 2;
    private static final int PREVIEW_BUTTON = 3;
    private static final int SPAWNPOINT_BUTTON = 4;
    private static final int TOP_OFFSET = 32;
    private static final int BOTTOM_OFFSET = 64;
    private static final int PADDING_X = 5;
    private final GuiCreateWorld parent;
    private final TerrariumWorldType worldType;
    protected GenerationSettings settings;
    protected CustomizationList activeList;
    protected CustomizationList categoryList;
    private PreviewRenderer previewRenderer;
    private PreviewController previewController;
    private boolean previewDirty = true;
    private long lastPreviewUpdateTime;
    private final WorldPreview preview = new WorldPreview();

    public EarthCustomizationGui(GuiCreateWorld parent, TerrariumWorldType worldType) {
        this.parent = parent;
        this.worldType = worldType;
        PropertySchema schema = worldType.buildPropertySchema();
        String settingsString = parent.field_146334_a;
        if (!Strings.isNullOrEmpty((String)settingsString)) {
            try {
                this.setSettings(GenerationSettings.parse(schema, settingsString));
            }
            catch (JsonSyntaxException e) {
                Terrarium.LOGGER.error("Failed to parse settings: {}", (Object)settingsString, (Object)e);
            }
        }
    }

    public void func_73866_w_() {
        int tabWidth = this.field_146294_l / 2 - 10;
        int tabHeight = this.field_146295_m - 32 - 64;
        int previewX = this.field_146294_l / 2 + 5;
        int previewY = 32;
        int propertiesX = 5;
        int propertiesY = 32;
        this.field_146292_n.clear();
        this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 - 154, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.func_189646_b(new GuiButton(1, this.field_146294_l / 2 + 4, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.func_189646_b(new GuiButton(2, this.field_146294_l / 2 - 154, this.field_146295_m - 52, 150, 20, I18n.func_135052_a((String)"gui.terrarium.preset", (Object[])new Object[0])));
        this.func_189646_b(new GuiButton(3, previewX + tabWidth - 20, previewY, 20, 20, "..."));
        this.func_189646_b(new GuiButton(4, this.field_146294_l / 2 + 4, this.field_146295_m - 52, 150, 20, I18n.func_135052_a((String)"gui.earth.spawnpoint", (Object[])new Object[0])));
        this.previewRenderer = new PreviewRenderer(this, (float)this.field_146294_l / 2.0f + 5.0f, previewY, tabWidth, tabHeight);
        this.previewController = new PreviewController(this.previewRenderer, 0.3f, 1.0f);
        Runnable onPropertyChange = () -> {
            this.previewDirty = true;
        };
        ActionButtonWidget upLevelButton = new ActionButtonWidget("<<"){

            @Override
            protected void handlePress() {
                EarthCustomizationGui.this.activeList = EarthCustomizationGui.this.categoryList;
            }
        };
        ArrayList<GuiButton> categoryListWidgets = new ArrayList<GuiButton>();
        Collection<CustomizationCategory> categories = this.worldType.getCustomization().getCategories();
        for (CustomizationCategory category : categories) {
            ArrayList<GuiButton> currentWidgets = new ArrayList<GuiButton>();
            currentWidgets.add((GuiButton)upLevelButton);
            for (CustomizationWidget widget : category.getWidgets()) {
                try {
                    currentWidgets.add(widget.createWidget(this.settings, onPropertyChange));
                }
                catch (Throwable t) {
                    Terrarium.LOGGER.error("Failed to create widget for {}", (Object)widget, (Object)t);
                }
            }
            final CustomizationList currentList = new CustomizationList(this.field_146297_k, this, propertiesX, propertiesY, tabWidth, tabHeight, currentWidgets);
            categoryListWidgets.add((GuiButton)new ActionButtonWidget(category.getLocalizedName()){

                @Override
                protected void handlePress() {
                    EarthCustomizationGui.this.activeList = currentList;
                }
            });
        }
        this.activeList = this.categoryList = new CustomizationList(this.field_146297_k, this, propertiesX, propertiesY, tabWidth, tabHeight, categoryListWidgets);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l && button.field_146125_m) {
            switch (button.field_146127_k) {
                case 0: {
                    this.parent.field_146334_a = this.settings.serializeString();
                    this.field_146297_k.func_147108_a((GuiScreen)this.parent);
                    break;
                }
                case 1: {
                    this.field_146297_k.func_147108_a((GuiScreen)this.parent);
                    break;
                }
                case 2: {
                    Consumer<TerrariumPreset> accept = preset -> {
                        this.applyPreset((TerrariumPreset)preset);
                        this.field_146297_k.func_147108_a((GuiScreen)this);
                    };
                    this.field_146297_k.func_147108_a((GuiScreen)new SelectPresetGui(accept, this, this.worldType));
                    break;
                }
                case 4: {
                    this.field_146297_k.func_147108_a((GuiScreen)new SelectEarthSpawnpointGui(this));
                    break;
                }
                case 3: {
                    this.field_146297_k.func_147108_a((GuiScreen)new LargePreviewGui(this.preview.retain(), this, this.settings.serializeString()));
                }
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.activeList != null) {
            this.activeList.func_148179_a(mouseX, mouseY, mouseButton);
        }
        this.previewController.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        super.func_146286_b(mouseX, mouseY, mouseButton);
        if (this.activeList != null) {
            this.activeList.func_148181_b(mouseX, mouseY, mouseButton);
        }
        this.previewController.mouseReleased(mouseX, mouseY, mouseButton);
    }

    protected void func_146273_a(int mouseX, int mouseY, int mouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, mouseButton, timeSinceLastClick);
        this.previewController.mouseDragged(mouseX, mouseY, mouseButton);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (this.activeList != null) {
            this.activeList.func_178039_p();
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)this.parent);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.previewDirty) {
            long time = System.currentTimeMillis();
            boolean previewExpired = time - this.lastPreviewUpdateTime > 200L;
            boolean generateInactive = this.preview.isGenerateInactive();
            if (previewExpired || generateInactive) {
                this.rebuildPreview();
                this.previewDirty = false;
                this.lastPreviewUpdateTime = time;
            }
        }
        this.previewController.update();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.previewController.updateMouse(mouseX, mouseY);
        this.func_146276_q_();
        this.drawPreview(partialTicks);
        if (this.activeList != null) {
            this.activeList.func_148128_a(mouseX, mouseY, partialTicks);
        }
        String title = I18n.func_135052_a((String)"options.terrarium.customize_world_title.name", (Object[])new Object[0]);
        this.func_73732_a(this.field_146289_q, title, this.field_146294_l / 2, 20, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void drawPreview(float partialTicks) {
        float zoom = this.previewController.getZoom(partialTicks);
        float rotationX = this.previewController.getRotationX(partialTicks);
        float rotationY = this.previewController.getRotationY(partialTicks);
        this.previewRenderer.render(this.preview, zoom, rotationX, rotationY);
    }

    public void applyPreset(TerrariumPreset preset) {
        this.setSettings(preset.createProperties(this.worldType.buildPropertySchema()));
        this.previewDirty = true;
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.preview.release();
    }

    public void applySpawnpoint(double latitude, double longitude) {
        this.settings.setDouble(EarthProperties.SPAWN_LATITUDE, latitude);
        this.settings.setDouble(EarthProperties.SPAWN_LONGITUDE, longitude);
        this.rebuildPreview();
    }

    private void rebuildPreview() {
        this.preview.rebuild(this.worldType, this.settings);
    }

    protected void setSettings(GenerationSettings settings) {
        this.settings = settings;
    }

    public GenerationSettings getSettings() {
        return this.settings;
    }
}

