/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.gengen.util.primer;

import dev.gegy.gengen.api.CubicPos;
import dev.gegy.gengen.api.writer.ChunkPrimeWriter;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CubicStructureUtil {
    public static void primeStructure(World world, ChunkPrimeWriter writer, CubicPos cubePos, Handler handler, int range, int spacingBitCount) {
        Random rand = new Random(world.func_72905_C());
        long randXMul = rand.nextLong();
        long randYMul = rand.nextLong();
        long randZMul = rand.nextLong();
        int spacing = 1 << spacingBitCount;
        int spacingBits = spacing - 1;
        int radius = range | spacingBits;
        int cubeXOriginBase = cubePos.getX() | spacingBits;
        int cubeYOriginBase = cubePos.getY() | spacingBits;
        int cubeZOriginBase = cubePos.getZ() | spacingBits;
        long randSeed = world.func_72905_C();
        for (int xOrigin = cubeXOriginBase - radius; xOrigin <= cubeXOriginBase + radius; xOrigin += spacing) {
            long randX = (long)xOrigin * randXMul ^ randSeed;
            for (int yOrigin = cubeYOriginBase - radius; yOrigin <= cubeYOriginBase + radius; yOrigin += spacing) {
                long randY = (long)yOrigin * randYMul ^ randX;
                for (int zOrigin = cubeZOriginBase - radius; zOrigin <= cubeZOriginBase + radius; zOrigin += spacing) {
                    long randZ = (long)zOrigin * randZMul ^ randY;
                    rand.setSeed(randZ);
                    handler.generate(rand, writer, xOrigin, yOrigin, zOrigin, cubePos);
                }
            }
        }
    }

    public static boolean scanWallsForBlock(ChunkPrimeWriter writer, StructureBoundingBox boundingBox, Predicate<IBlockState> predicate) {
        int z;
        int x;
        int minX = boundingBox.field_78897_a;
        int minY = boundingBox.field_78895_b;
        int minZ = boundingBox.field_78896_c;
        int maxX = boundingBox.field_78893_d;
        int maxY = boundingBox.field_78894_e;
        int maxZ = boundingBox.field_78892_f;
        for (x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                if (!predicate.test(writer.get(x, y, minZ)) && !predicate.test(writer.get(x, y, maxZ - 1))) continue;
                return true;
            }
        }
        for (x = minX; x < maxX; ++x) {
            for (z = minZ; z < maxZ; ++z) {
                if (!predicate.test(writer.get(x, minY, z)) && !predicate.test(writer.get(x, maxY - 1, z))) continue;
                return true;
            }
        }
        for (int y = minY; y < maxY; ++y) {
            for (z = minZ; z < maxZ; ++z) {
                if (!predicate.test(writer.get(minX, y, z)) && !predicate.test(writer.get(maxX - 1, y, z))) continue;
                return true;
            }
        }
        return false;
    }

    public static double normalizedDistance(int cubeOriginCoord, int localCoord, double structureCoord, double scale) {
        int globalCoord = (cubeOriginCoord << 4) + localCoord;
        return ((double)globalCoord + 0.5 - structureCoord) / scale;
    }

    public static void clampBoundingBoxToLocalCube(StructureBoundingBox boundingBox) {
        if (boundingBox.field_78897_a < 0) {
            boundingBox.field_78897_a = 0;
        }
        if (boundingBox.field_78893_d > 16) {
            boundingBox.field_78893_d = 16;
        }
        if (boundingBox.field_78895_b < 0) {
            boundingBox.field_78895_b = 0;
        }
        if (boundingBox.field_78894_e > 16) {
            boundingBox.field_78894_e = 16;
        }
        if (boundingBox.field_78896_c < 0) {
            boundingBox.field_78896_c = 0;
        }
        if (boundingBox.field_78892_f > 16) {
            boundingBox.field_78892_f = 16;
        }
    }

    @FunctionalInterface
    public static interface Handler {
        public void generate(Random var1, ChunkPrimeWriter var2, int var3, int var4, int var5, CubicPos var6);
    }
}

