/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.gengen.core.impl.cubic;

import dev.gegy.gengen.api.GenericWorldType;
import dev.gegy.gengen.api.generator.GenericChunkGenerator;
import dev.gegy.gengen.core.impl.cubic.CubeGeneratorImpl;
import dev.gegy.gengen.core.impl.vanilla.ColumnWorldTypeImpl;
import io.github.opencubicchunks.cubicchunks.api.util.IntRange;
import io.github.opencubicchunks.cubicchunks.api.world.ICubicWorldType;
import io.github.opencubicchunks.cubicchunks.api.worldgen.ICubeGenerator;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CubeWorldTypeImpl
extends ColumnWorldTypeImpl
implements ICubicWorldType {
    public CubeWorldTypeImpl(GenericWorldType worldType) {
        super(worldType);
    }

    @Nullable
    public ICubeGenerator createCubeGenerator(World world) {
        GenericChunkGenerator generator = this.worldType.createGenerator(world);
        return new CubeGeneratorImpl(world, generator);
    }

    public IntRange calculateGenerationHeightRange(WorldServer world) {
        return new IntRange(this.worldType.getMinGenerationHeight(world), this.worldType.getMaxGenerationHeight(world));
    }

    public boolean hasCubicGeneratorForWorld(World world) {
        return world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD;
    }
}

