/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import sereneseasons.config.json.BiomeData;
import sereneseasons.util.config.JsonUtil;

public class BiomeConfig {
    public static final Map<ResourceLocation, BiomeData> biomeDataMap = Maps.newHashMap();

    public static void init(File configDir) {
        HashMap defaultBiomeData = Maps.newHashMap();
        BiomeConfig.addBlacklistedBiomes(defaultBiomeData);
        BiomeConfig.addTropicalBiomes(defaultBiomeData);
        BiomeConfig.addDisabledCropBiomes(defaultBiomeData);
        biomeDataMap.clear();
        Map tmpBiomeDataMap = JsonUtil.getOrCreateConfigFile(configDir, "biome_info.json", defaultBiomeData, new TypeToken<Map<String, BiomeData>>(){}.getType());
        if (tmpBiomeDataMap != null && !tmpBiomeDataMap.isEmpty()) {
            for (Map.Entry entry : tmpBiomeDataMap.entrySet()) {
                biomeDataMap.put(new ResourceLocation((String)entry.getKey()), (BiomeData)entry.getValue());
            }
        }
    }

    public static boolean enablesSeasonalEffects(Biome biome) {
        ResourceLocation name = biome.getRegistryName();
        if (biomeDataMap.containsKey(name)) {
            return BiomeConfig.biomeDataMap.get((Object)name).enableSeasonalEffects;
        }
        return true;
    }

    public static boolean usesTropicalSeasons(Biome biome) {
        ResourceLocation name = biome.getRegistryName();
        if (biomeDataMap.containsKey(name)) {
            return BiomeConfig.biomeDataMap.get((Object)name).useTropicalSeasons;
        }
        return false;
    }

    public static boolean disablesCrops(Biome biome) {
        ResourceLocation name = biome.getRegistryName();
        if (biomeDataMap.containsKey(name)) {
            return BiomeConfig.biomeDataMap.get((Object)name).disableCrops;
        }
        return false;
    }

    private static void addBlacklistedBiomes(Map<String, BiomeData> map) {
        ArrayList blacklistedBiomes = Lists.newArrayList((Object[])new String[]{"minecraft:mushroom_island", "minecraft:mushroom_island_shore", "minecraft:ocean", "minecraft:deep_ocean", "minecraft:river", "biomesoplenty:mystic_grove", "biomesoplenty:ominous_woods", "biomesoplenty:wasteland", "biomesoplenty:flower_island", "biomesoplenty:coral_reef", "biomesoplenty:kelp_forest", "thaumcraft:magical_forest", "integrateddynamics:biome_meneglin", "abyssalcraft:darklands", "abyssalcraft:darklands_forest", "abyssalcraft:darklands_plains", "abyssalcraft:darklands_hills", "abyssalcraft:darklands_mountains", "abyssalcraft:coralium_infested_swamp"});
        for (String biomeName : blacklistedBiomes) {
            if (!map.containsKey(biomeName)) {
                map.put(biomeName, new BiomeData(false, false, false));
                continue;
            }
            map.get((Object)biomeName).enableSeasonalEffects = false;
        }
    }

    private static void addTropicalBiomes(Map<String, BiomeData> map) {
        ArrayList tropicalBiomes = Lists.newArrayList((Object[])new String[]{"minecraft:desert", "minecraft:desert_hills", "minecraft:mutated_desert", "minecraft:jungle", "minecraft:jungle_hills", "minecraft:jungle_edge", "minecraft:mutated_jungle", "minecraft:mutated_jungle_edge", "minecraft:mesa", "minecraft:mesa_rock", "minecraft:mesa_clear_rock", "minecraft:mutated_mesa", "minecraft:mutated_mesa_rock", "minecraft:mutated_mesa_clear_rock", "minecraft:savanna", "minecraft:savanna_rock", "minecraft:mutated_savanna", "minecraft:mutated_savanna_rock", "minecraft:mushroom_island", "minecraft:mushroom_island_shore", "biomesoplenty:bamboo_forest", "biomesoplenty:bayou", "biomesoplenty:brushland", "biomesoplenty:eucalyptus_forest", "biomesoplenty:floodplains", "biomesoplenty:lush_desert", "biomesoplenty:mangrove", "biomesoplenty:outback", "biomesoplenty:overgrown_cliffs", "biomesoplenty:rainforest", "biomesoplenty:sacred_springs", "biomesoplenty:scrubland", "biomesoplenty:tropical_rainforest", "biomesoplenty:wasteland", "biomesoplenty:xeric_shrubland", "biomesoplenty:flower_island", "biomesoplenty:tropical_island", "biomesoplenty:volcanic_island", "biomesoplenty:oasis", "biomesoplenty:white_beach", "traverse:arid_highland", "traverse:badlands", "traverse:canyon", "traverse:desert_shrubland", "traverse:mini_jungle", "traverse:mountainous_desert", "traverse:red_desert", "conquest:bamboo_forest", "conquest:desert_mod", "conquest:jungle_mod", "conquest:mesa_extreme_mod", "conquest:red_desert", "climaticbiomesjbg:subtropical_forest", "climaticbiomesjbg:subtropical_forest_hills", "climaticbiomesjbg:tropical_forest", "climaticbiomesjbg:tropical_forest_hills", "climaticbiomesjbg:pine_swamp", "climaticbiomesjbg:dense_scrub", "climaticbiomesjbg:dense_scrub_hills", "climaticbiomesjbg:dense_scrub_hills", "climaticbiomesjbg:dry_scrub", "climaticbiomesjbg:dry_scrub_hills", "climaticbiomesjbg:hot_mountain", "climaticbiomesjbg:hot_mountain_trees"});
        for (String biomeName : tropicalBiomes) {
            if (!map.containsKey(biomeName)) {
                map.put(biomeName, new BiomeData(true, true, false));
                continue;
            }
            map.get((Object)biomeName).useTropicalSeasons = true;
        }
    }

    private static void addDisabledCropBiomes(Map<String, BiomeData> map) {
        ArrayList disabledCropBiomes = Lists.newArrayList((Object[])new String[]{"biomesoplenty:crag", "biomesoplenty:wasteland", "biomesoplenty:volcanic_island"});
        for (String biomeName : disabledCropBiomes) {
            if (!map.containsKey(biomeName)) {
                map.put(biomeName, new BiomeData(false, false, true));
                continue;
            }
            map.get((Object)biomeName).disableCrops = true;
        }
    }
}

