/*
 * Decompiled with CFR 0.152.
 */
package com.animania.addons.catsdogs.client.render.cats;

import com.animania.addons.catsdogs.common.entity.felids.EntityAnimaniaCat;
import com.animania.api.interfaces.IChild;
import com.animania.client.render.layer.LayerBlinking;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderCatGeneric<T extends EntityAnimaniaCat>
extends RenderLiving<T> {
    private final ResourceLocation texture;
    private final ResourceLocation blink;
    private final int eyeColor;
    private final float scale;

    public RenderCatGeneric(RenderManager rm, ModelBase model, ResourceLocation texture, ResourceLocation blink, int eyeColor, float scale) {
        super(rm, model, 0.2f);
        this.texture = texture;
        this.blink = blink;
        this.eyeColor = eyeColor;
        this.scale = scale;
        this.func_177094_a((LayerRenderer)new LayerBlinking((RenderLiving)this, blink, eyeColor));
    }

    protected void preRenderScale(EntityAnimaniaCat entity, float f) {
        if (entity instanceof IChild) {
            IChild child = (IChild)((Object)entity);
            float age = child.getEntityAge();
            double dividend = 0.85 / (0.8 * (double)this.scale);
            GlStateManager.func_179139_a((double)((double)this.scale + (double)age / dividend), (double)((double)this.scale + (double)age / dividend), (double)((double)this.scale + (double)age / dividend));
            this.field_76989_e = (this.scale + age) / 2.0f;
        } else {
            GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)this.scale);
            this.field_76989_e = this.scale / 2.0f;
        }
        EntityAnimaniaCat entityCat = entity;
        if (entityCat.getSleeping()) {
            this.field_76989_e = 0.0f;
            float sleepTimer = entityCat.getSleepTimer().floatValue();
            if (sleepTimer > -0.55f) {
                sleepTimer -= 0.01f;
            }
            entity.setSleepTimer(Float.valueOf(sleepTimer));
            GlStateManager.func_179109_b((float)-0.25f, (float)(entity.field_70131_O - 2.0f - sleepTimer), (float)-0.25f);
            GlStateManager.func_179114_b((float)6.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)0.0, (double)0.6, (double)0.0);
            if (entity instanceof IChild) {
                GlStateManager.func_179137_b((double)0.0, (double)0.4, (double)0.0);
            }
        } else {
            entityCat.setSleeping(false);
            entityCat.setSleepTimer(Float.valueOf(0.0f));
        }
    }

    protected ResourceLocation getEntityTexture(T entity) {
        return this.texture;
    }

    protected void preRenderCallback(T entityliving, float f) {
        this.preRenderScale((EntityAnimaniaCat)entityliving, f);
    }

    public static class Factory<T extends EntityAnimaniaCat>
    implements IRenderFactory<T> {
        ResourceLocation tex;
        ResourceLocation blink;
        int eye;
        float scale;
        ModelBase model;

        public Factory(ModelBase model, ResourceLocation texture, ResourceLocation blink, int eyeCol, float scale) {
            this.tex = texture;
            this.blink = blink;
            this.eye = eyeCol;
            this.scale = scale;
            this.model = model;
        }

        public Render<? super T> createRenderFor(RenderManager manager) {
            return new RenderCatGeneric(manager, this.model, this.tex, this.blink, this.eye, this.scale);
        }
    }
}

