/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.part;

import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.gui.overlay.Readouts;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.model.ModelState;
import cam72cam.immersiverailroading.model.components.ComponentProvider;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.immersiverailroading.model.part.Control;
import cam72cam.immersiverailroading.util.DataBlock;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Readout<T extends EntityMoveableRollingStock>
extends Control<T> {
    private final Map<UUID, Float> positions = new HashMap<UUID, Float>();
    private final Function<T, Float> position;
    private final float rangeMin;
    private final float rangeMax;

    public static <T extends EntityMoveableRollingStock> List<Readout<T>> getReadouts(ComponentProvider provider, ModelState state, ModelComponentType type, Readouts value) {
        return provider.parseAll(type).stream().map(p -> new Readout<EntityMoveableRollingStock>((ModelComponent)p, value::getValue, state, provider.internal_model_scale, provider.widgetConfig)).collect(Collectors.toList());
    }

    public static <T extends EntityMoveableRollingStock> List<Readout<T>> getReadouts(ComponentProvider provider, ModelState state, ModelComponentType type, ModelComponentType.ModelPosition pos, Readouts value) {
        return provider.parseAll(type, pos).stream().map(p -> new Readout<EntityMoveableRollingStock>((ModelComponent)p, value::getValue, state, provider.internal_model_scale, provider.widgetConfig)).collect(Collectors.toList());
    }

    public Readout(ModelComponent part, Function<T, Float> position, ModelState state, double internal_model_scale, Map<String, DataBlock> widgetConfig) {
        super(part, state, internal_model_scale, widgetConfig);
        this.position = position;
        float min = 0.0f;
        float max = 1.0f;
        Pattern pattern = Pattern.compile("_RANGE_([^_]*)_([^_]*)");
        for (String modelID : part.modelIDs) {
            Matcher matcher = pattern.matcher(modelID);
            while (matcher.find()) {
                min = Float.parseFloat(matcher.group(1));
                max = Float.parseFloat(matcher.group(2));
            }
        }
        this.rangeMin = min;
        this.rangeMax = max;
    }

    @Override
    public void effects(T stock) {
        super.effects(stock);
        this.positions.put(stock.getUUID(), this.position.apply(stock));
    }

    @Override
    public float getValue(EntityMoveableRollingStock stock) {
        float pos = this.positions.getOrDefault(stock.getUUID(), Float.valueOf(0.0f)).floatValue();
        pos = Math.min(1.0f, Math.max(0.0f, (pos - this.rangeMin) / (this.rangeMax - this.rangeMin)));
        return this.invert ? 1.0f - pos : (pos += this.offset);
    }
}

