/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.items;

import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.items.ItemRailAugment;
import cam72cam.immersiverailroading.items.ItemTabs;
import cam72cam.immersiverailroading.library.Augment;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.Permissions;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.multiblock.MultiblockRegistry;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.util.BlockUtil;
import cam72cam.immersiverailroading.util.IRFuzzy;
import cam72cam.immersiverailroading.util.VecUtil;
import cam72cam.mod.entity.Player;
import cam72cam.mod.item.ClickResult;
import cam72cam.mod.item.CreativeTab;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.Fuzzy;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.util.Facing;
import cam72cam.mod.world.World;
import java.util.Collections;
import java.util.List;

public class ItemLargeWrench
extends CustomItem {
    public ItemLargeWrench() {
        super("immersiverailroading", "item_large_wrench");
        Fuzzy steel = Fuzzy.STEEL_INGOT;
        IRFuzzy.registerSteelRecipe(this, 3, null, steel, null, steel, steel, steel, steel, null, steel);
    }

    public int getStackSize() {
        return 1;
    }

    public List<CreativeTab> getCreativeTabs() {
        return Collections.singletonList(ItemTabs.MAIN_TAB);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ClickResult onClickBlock(Player player, World world, Vec3i pos, Player.Hand hand, Facing facing, Vec3d hit) {
        if (BlockUtil.isIRRail(world, pos)) {
            TileRailBase te = (TileRailBase)world.getBlockEntity(pos, TileRailBase.class);
            if (te == null) return ClickResult.PASS;
            Augment augment = te.getAugment();
            if (augment != null) {
                te.setAugment(null);
                if (!world.isServer || !player.hasPermission(Permissions.AUGMENT_TRACK)) return ClickResult.ACCEPTED;
                ItemStack stack = new ItemStack((CustomItem)IRItems.ITEM_AUGMENT, 1);
                ItemRailAugment.Data data = new ItemRailAugment.Data(stack);
                data.augment = augment;
                data.gauge = Gauge.from(te.getTrackGauge());
                data.write();
                world.dropItem(stack, pos);
                return ClickResult.ACCEPTED;
            }
            if (!world.isServer) return ClickResult.PASS;
            while (te != null) {
                System.out.println(te);
                TileRail parent = te.getParentTile();
                if (parent != null && parent.info.settings.type == TrackItems.TURNTABLE) {
                    parent.setTablePosition(VecUtil.toWrongYaw(new Vec3d(parent.getPos()).add(0.5, 0.0, 0.5).subtract(hit.add(pos))) + parent.info.placementInfo.yaw);
                    return ClickResult.PASS;
                }
                te = te.getReplacedTile();
            }
            return ClickResult.PASS;
        }
        if (!player.hasPermission(Permissions.MACHINIST)) return ClickResult.PASS;
        for (String key : MultiblockRegistry.keys()) {
            if (!MultiblockRegistry.get(key).tryCreate(world, pos)) continue;
            return ClickResult.ACCEPTED;
        }
        return ClickResult.PASS;
    }
}

