/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity.physics.chrono;

import cam72cam.immersiverailroading.entity.physics.chrono.ChronoState;
import cam72cam.immersiverailroading.entity.physics.chrono.ClientChronoState;
import cam72cam.mod.net.Packet;
import cam72cam.mod.net.PacketDirection;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.world.World;
import java.util.HashMap;
import java.util.Map;

public class ServerChronoState
extends Packet
implements ChronoState {
    private static final Map<World, ServerChronoState> states = new HashMap<World, ServerChronoState>();
    @TagField
    protected World world;
    @TagField
    protected int tickID;
    @TagField
    protected double ticksPerSecond;

    private ServerChronoState() {
    }

    private ServerChronoState(World world) {
        this.world = world;
        this.tickID = 0;
        this.ticksPerSecond = 20.0;
    }

    private void tick() {
        ++this.tickID;
        this.ticksPerSecond = this.world.getTPS(20);
        if (this.tickID % 5 == 0) {
            this.sendToAll();
        }
    }

    protected void handle() {
        ClientChronoState.updated(this);
    }

    @Override
    public double getTickID() {
        return this.tickID;
    }

    @Override
    public double getTickSkew() {
        return 1.0;
    }

    public int getServerTickID() {
        return this.tickID;
    }

    public static ServerChronoState getState(World world) {
        return states.computeIfAbsent(world, ServerChronoState::new);
    }

    public static void register() {
        ServerChronoState.register(ServerChronoState::new, (PacketDirection)PacketDirection.ServerToClient);
    }

    static {
        World.onTick(w -> {
            ServerChronoState state = ServerChronoState.getState(w);
            if (state != null) {
                state.tick();
            }
        });
    }
}

