/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.AdvancedRocketryAPI;
import zmaster587.advancedRocketry.api.IGravityManager;
import zmaster587.advancedRocketry.api.IPlanetaryProvider;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.world.provider.WorldProviderSpace;

public class GravityHandler
implements IGravityManager {
    public static final float LIVING_OFFSET = 0.0755f;
    public static final float FLUID_LIVING_OFFSET = 0.02f;
    public static final float THROWABLE_OFFSET = 0.03f;
    public static final float OTHER_OFFSET = 0.04f;
    public static final float ARROW_OFFSET = 0.05f;
    static Class gcWorldProvider;
    static Method gcGetGravity;
    private static WeakHashMap<Entity, Double> entityMap;

    public static void applyGravity(Entity entity) {
        if (entity.func_189652_ae()) {
            return;
        }
        if (!(entity instanceof EntityPlayer) && !(entity instanceof EntityFlying) || !(entity instanceof EntityFlying) && !((EntityPlayer)entity).field_71075_bZ.field_75100_b && !((EntityLivingBase)entity).func_184613_cA()) {
            Double d;
            if (entityMap.containsKey(entity) && (d = entityMap.get(entity)) != null) {
                double multiplier = GravityHandler.isOtherEntity(entity) || entity instanceof EntityItem ? (double)0.04f * d : (entity instanceof EntityArrow ? (double)0.05f * d : (entity instanceof EntityThrowable ? (double)0.03f * d : (double)0.0755f * d));
                entity.field_70181_x += multiplier;
            } else if (DimensionManager.getInstance().isDimensionCreated(entity.field_70170_p.field_73011_w.getDimension()) || entity.field_70170_p.field_73011_w instanceof WorldProviderSpace) {
                double gravMult = entity.field_70170_p.field_73011_w instanceof IPlanetaryProvider ? ((IPlanetaryProvider)entity.field_70170_p.field_73011_w).getGravitationalMultiplier(entity.func_180425_c()) : (double)DimensionManager.getInstance().getDimensionProperties((int)entity.field_70170_p.field_73011_w.getDimension()).gravitationalMultiplier;
                if (entity instanceof EntityItem) {
                    entity.field_70181_x -= gravMult * (double)0.04f - (double)0.04f;
                } else if (GravityHandler.isOtherEntity(entity)) {
                    entity.field_70181_x -= gravMult * (double)0.04f - (double)0.04f;
                } else if (entity instanceof EntityThrowable) {
                    entity.field_70181_x -= gravMult * (double)0.03f - (double)0.03f;
                } else if (entity instanceof EntityArrow) {
                    entity.field_70181_x -= gravMult * (double)0.05f - (double)0.05f;
                } else if (entity instanceof EntityLivingBase && entity.func_70090_H() || entity.func_180799_ab()) {
                    entity.field_70181_x -= gravMult * (double)0.02f - (double)0.02f;
                } else if (entity instanceof EntityLivingBase) {
                    entity.field_70181_x -= gravMult * (double)0.0755f - (double)0.0755f;
                }
            } else if (gcWorldProvider != null && gcWorldProvider.isAssignableFrom(entity.field_70170_p.field_73011_w.getClass())) {
                try {
                    entity.field_70181_x -= (double)(0.0755f - ((Float)gcGetGravity.invoke((Object)entity.field_70170_p.field_73011_w, new Object[0])).floatValue());
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean isOtherEntity(Entity entity) {
        return entity instanceof EntityBoat || entity instanceof EntityMinecart || entity instanceof EntityFallingBlock || entity instanceof EntityTNTPrimed;
    }

    @Override
    public void setGravityMultiplier(Entity entity, double multiplier) {
        entityMap.put(entity, multiplier);
    }

    @Override
    public void clearGravityEffect(Entity entity) {
        entityMap.remove(entity);
    }

    static {
        AdvancedRocketryAPI.gravityManager = new GravityHandler();
        try {
            gcWorldProvider = Class.forName("micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider");
            AdvancedRocketry.logger.info("GC IGalacticraftWorldProvider  found");
            gcGetGravity = gcWorldProvider.getMethod("getGravity", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            gcWorldProvider = null;
            AdvancedRocketry.logger.info("GC IGalacticraftWorldProvider not found");
        }
        entityMap = new WeakHashMap();
    }
}

