/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock.machine;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryAPI;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.armor.ItemSpaceArmor;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.util.AudioRegistry;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.interfaces.IRecipe;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleProgress;
import zmaster587.libVulpes.recipe.NumberedOreDictStack;
import zmaster587.libVulpes.recipe.RecipesMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiblockMachine;

public class TileChemicalReactor
extends TileMultiblockMachine {
    public static final Object[][][] structure = new Object[][][]{{{null, Character.valueOf('c'), null}, {Character.valueOf('L'), Character.valueOf('I'), Character.valueOf('L')}}, {{Character.valueOf('P'), LibVulpesBlocks.motors, Character.valueOf('P')}, {Character.valueOf('l'), Character.valueOf('O'), Character.valueOf('l')}}};

    public boolean shouldHideBlock(World world, BlockPos pos, IBlockState tile) {
        return true;
    }

    public void onInventoryUpdated() {
        IRecipe recipe;
        boolean flag = false;
        if (this.getOutputs() == null && (recipe = this.getRecipe(this.getMachineRecipeList())) != null && this.canProcessRecipe(recipe) && !recipe.getOutput().isEmpty()) {
            NBTTagList list = ((ItemStack)recipe.getOutput().get(0)).func_77986_q();
            flag = true;
        }
        if (flag && this.getOutputs() == null) {
            if (this.enabled && (recipe = this.getRecipe(this.getMachineRecipeList())) != null && this.canProcessRecipe(recipe)) {
                this.consumeItemsSpecial(recipe);
                this.setOutputFluids(new LinkedList());
                this.powerPerTick = (int)Math.ceil(this.getPowerMultiplierForRecipe(recipe) * (float)recipe.getPower());
                this.completionTime = Math.max((int)(this.getTimeMultiplierForRecipe(recipe) * (float)recipe.getTime()), 1);
                this.func_70296_d();
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
                this.setMachineRunning(true);
            } else {
                this.setMachineRunning(false);
            }
        } else {
            super.onInventoryUpdated();
        }
    }

    public void consumeItemsSpecial(IRecipe recipe) {
        List ingredients = recipe.getIngredients();
        block0: for (List ingredient : ingredients) {
            for (IInventory hatch : this.itemInPorts) {
                for (int i = 0; i < hatch.func_70302_i_(); ++i) {
                    ItemStack stackInSlot = hatch.func_70301_a(i);
                    for (ItemStack stack : ingredient) {
                        if (stackInSlot.func_190926_b() || stackInSlot.func_190916_E() < stack.func_190916_E() || stackInSlot.func_77973_b() != stack.func_77973_b() || stackInSlot.func_77952_i() != stack.func_77952_i() && stack.func_77952_i() != Short.MAX_VALUE) continue;
                        ItemStack stack2 = hatch.func_70298_a(i, stack.func_190916_E());
                        if (stack2.func_77973_b() instanceof ItemArmor) {
                            stack2.func_77966_a(AdvancedRocketryAPI.enchantmentSpaceProtection, 1);
                            LinkedList<ItemStack> list = new LinkedList<ItemStack>();
                            list.add(stack2);
                            this.setOutputs(list);
                        }
                        hatch.func_70296_d();
                        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(((TileEntity)hatch).func_174877_v()), this.field_145850_b.func_180495_p(((TileEntity)hatch).func_174877_v()), 6);
                        continue block0;
                    }
                }
            }
        }
    }

    public void registerRecipes() {
        if (ARConfiguration.getCurrentConfig().enableOxygen) {
            for (ResourceLocation key : Item.field_150901_e.func_148742_b()) {
                Item item = (Item)Item.field_150901_e.func_82594_a((Object)key);
                if (!(item instanceof ItemArmor) || item instanceof ItemSpaceArmor) continue;
                ItemStack enchanted = new ItemStack(item);
                enchanted.func_77966_a(AdvancedRocketryAPI.enchantmentSpaceProtection, 1);
                if (((ItemArmor)item).field_77881_a == EntityEquipmentSlot.CHEST) {
                    RecipesMachine.getInstance().addRecipe(TileChemicalReactor.class, (Object)enchanted, 100, 10, new Object[]{new ItemStack(item, 1, Short.MAX_VALUE), new ItemStack(AdvancedRocketryBlocks.blockPipeSealer, 1), new NumberedOreDictStack("sheetTitaniumAluminide", 4), new ItemStack(AdvancedRocketryItems.itemPressureTank, 1, 3)});
                    continue;
                }
                RecipesMachine.getInstance().addRecipe(TileChemicalReactor.class, (Object)enchanted, 100, 10, new Object[]{new ItemStack(item, 1, Short.MAX_VALUE), new ItemStack(AdvancedRocketryBlocks.blockPipeSealer, 1), new NumberedOreDictStack("sheetTitaniumAluminide", 4)});
            }
        }
    }

    public Object[][][] getStructure() {
        return structure;
    }

    public SoundEvent getSound() {
        return AudioRegistry.rollingMachine;
    }

    public int getSoundDuration() {
        return 30;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-2, -2, -2), this.field_174879_c.func_177982_a(2, 2, 2));
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        List modules = super.getModules(ID, player);
        modules.add(new ModuleProgress(100, 4, 0, TextureResources.crystallizerProgressBar, (IProgressBar)this));
        return modules;
    }

    public String getMachineName() {
        return AdvancedRocketryBlocks.blockChemicalReactor.func_149732_F();
    }
}

