/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.atmosphere;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AreaBlob;
import zmaster587.advancedRocketry.api.IAtmosphere;
import zmaster587.advancedRocketry.api.event.AtmosphereEvent;
import zmaster587.advancedRocketry.api.util.IBlobHandler;
import zmaster587.advancedRocketry.atmosphere.AtmosphereType;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.network.PacketAtmSync;
import zmaster587.advancedRocketry.util.AtmosphereBlob;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.HashedBlockPosition;

public class AtmosphereHandler {
    public static final DamageSource vacuumDamage = new DamageSource("Vacuum").func_76348_h().func_151518_m();
    public static final DamageSource lowOxygenDamage = new DamageSource("LowOxygen").func_76348_h().func_151518_m();
    public static final DamageSource heatDamage = new DamageSource("Heat").func_76348_h().func_151518_m();
    public static final DamageSource oxygenToxicityDamage = new DamageSource("OxygenToxicity").func_76348_h().func_151518_m();
    public static long lastSuffocationTime = Integer.MIN_VALUE;
    private static final int MAX_BLOB_RADIUS = (ARConfiguration.getCurrentConfig().atmosphereHandleBitMask & 1) == 1 ? 256 : ARConfiguration.getCurrentConfig().oxygenVentSize;
    private static HashMap<Integer, AtmosphereHandler> dimensionOxygen = new HashMap();
    private static HashMap<EntityPlayer, IAtmosphere> prevAtmosphere = new HashMap();
    private HashMap<IBlobHandler, AreaBlob> blobs;
    private int dimId;
    public static IAtmosphere currentAtm;
    public static int currentPressure;

    public static void registerWorld(int dimId) {
        DimensionProperties dimProp = DimensionManager.getInstance().getDimensionProperties(dimId);
        if (ARConfiguration.getCurrentConfig().enableOxygen && dimProp.hasSurface() && (ARConfiguration.getCurrentConfig().overrideGCAir || dimId != ARConfiguration.getCurrentConfig().MoonId || dimProp.isNativeDimension)) {
            dimensionOxygen.put(dimId, new AtmosphereHandler(dimId));
            MinecraftForge.EVENT_BUS.register((Object)dimensionOxygen.get(dimId));
        }
    }

    public static void unregisterWorld(int dimId) {
        AtmosphereHandler handler = dimensionOxygen.remove(dimId);
        if (ARConfiguration.getCurrentConfig().enableOxygen && handler != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)handler);
            FMLCommonHandler.instance().bus().unregister((Object)handler);
        }
    }

    private AtmosphereHandler(int dimId) {
        this.dimId = dimId;
        this.blobs = new HashMap();
    }

    @SubscribeEvent
    public void onTick(LivingEvent.LivingUpdateEvent event) {
        Entity entity = event.getEntity();
        if (!entity.field_70170_p.field_72995_K && entity.field_70170_p.field_73011_w.getDimension() == this.dimId) {
            IAtmosphere atmosType = this.getAtmosphereType(entity);
            if (entity instanceof EntityPlayer && atmosType != prevAtmosphere.get(entity)) {
                PacketHandler.sendToPlayer((BasePacket)new PacketAtmSync(atmosType.getUnlocalizedName(), this.getAtmospherePressure(entity)), (EntityPlayer)((EntityPlayer)entity));
                prevAtmosphere.put((EntityPlayer)entity, atmosType);
            }
            if (atmosType.canTick() && !event.getEntityLiving().func_180799_ab() && !event.getEntityLiving().func_70055_a(Material.field_151586_h)) {
                AtmosphereEvent.AtmosphereTickEvent event2 = new AtmosphereEvent.AtmosphereTickEvent(entity, atmosType);
                MinecraftForge.EVENT_BUS.post((Event)event2);
                if (!event2.isCanceled() && !atmosType.isImmune(event.getEntity().getClass())) {
                    atmosType.onTick(event.getEntityLiving());
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangeDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        prevAtmosphere.remove(event.player);
    }

    @SubscribeEvent
    public void onPlayerLogoutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        prevAtmosphere.remove(event.player);
    }

    private void onBlockRemove(HashedBlockPosition pos) {
        List<AreaBlob> blobs = this.getBlobWithinRadius(pos, MAX_BLOB_RADIUS);
        block0: for (AreaBlob blob : blobs) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (!blob.contains(pos.getPositionAtOffset(dir))) continue;
                blob.addBlock(pos, blobs);
                continue block0;
            }
        }
    }

    public static boolean hasAtmosphereHandler(int dimId) {
        return dimensionOxygen.containsKey(dimId);
    }

    public static void onBlockChange(@Nonnull World world, @Nonnull BlockPos bpos) {
        if (ARConfiguration.getCurrentConfig().enableOxygen && !world.field_72995_K && world.func_175726_f(new BlockPos((Vec3i)bpos)).func_177410_o()) {
            IFluidBlock fluidblock;
            HashedBlockPosition pos = new HashedBlockPosition(bpos);
            AtmosphereHandler handler = AtmosphereHandler.getOxygenHandler(world.field_73011_w.getDimension());
            if (handler == null) {
                return;
            }
            if (handler.getAtmosphereType(bpos) == AtmosphereType.SUPERHEATED) {
                if (world.func_180495_p(bpos).func_177230_c().isLeaves(world.func_180495_p(bpos), (IBlockAccess)world, bpos)) {
                    world.func_175698_g(bpos);
                } else if (world.func_180495_p(bpos).func_185904_a() == Material.field_151570_A) {
                    world.func_175656_a(bpos, Blocks.field_150480_ab.func_176223_P());
                } else if (world.func_180495_p(bpos).func_185904_a() == Material.field_151585_k) {
                    world.func_175656_a(bpos, Blocks.field_150480_ab.func_176223_P());
                } else if (world.func_180495_p(bpos).func_185904_a() == Material.field_151582_l) {
                    world.func_175656_a(bpos, Blocks.field_150480_ab.func_176223_P());
                } else if (world.func_180495_p(bpos).func_177230_c().isLeaves(world.func_180495_p(bpos), (IBlockAccess)world, bpos)) {
                    world.func_175656_a(bpos, Blocks.field_150480_ab.func_176223_P());
                } else if (world.func_180495_p(bpos).func_185904_a() == Material.field_151575_d) {
                    world.func_175656_a(bpos, Blocks.field_150480_ab.func_176223_P());
                } else if (world.func_180495_p(bpos).func_185904_a() == Material.field_151569_G) {
                    world.func_175656_a(bpos, Blocks.field_150480_ab.func_176223_P());
                } else if (world.func_180495_p(bpos).func_185904_a() == Material.field_151593_r) {
                    world.func_175656_a(bpos, Blocks.field_150480_ab.func_176223_P());
                } else if (world.func_180495_p(bpos).func_185904_a() == Material.field_151580_n) {
                    world.func_175656_a(bpos, Blocks.field_150480_ab.func_176223_P());
                } else if (world.func_180495_p(bpos).func_185904_a() == Material.field_151572_C) {
                    world.func_175656_a(bpos, Blocks.field_150480_ab.func_176223_P());
                }
            } else if (!handler.getAtmosphereType(bpos).allowsCombustion()) {
                if (world.func_180495_p(bpos).func_177230_c().isLeaves(world.func_180495_p(bpos), (IBlockAccess)world, bpos)) {
                    world.func_175698_g(bpos);
                } else if (world.func_180495_p(bpos).func_185904_a() == Material.field_151581_o) {
                    world.func_175698_g(bpos);
                } else if (world.func_180495_p(bpos).func_185904_a() == Material.field_151570_A) {
                    world.func_175698_g(bpos);
                } else if (world.func_180495_p(bpos).func_185904_a() == Material.field_151585_k && world.func_180495_p(bpos).func_177230_c() != Blocks.field_150330_I) {
                    world.func_175656_a(bpos, Blocks.field_150330_I.func_176223_P());
                } else if (world.func_180495_p(bpos).func_185904_a() == Material.field_151582_l) {
                    world.func_175698_g(bpos);
                } else if (world.func_180495_p(bpos).func_185904_a() == Material.field_151577_b) {
                    world.func_175656_a(bpos, Blocks.field_150346_d.func_176223_P());
                }
            }
            if (handler.getAtmosphereType(bpos) == AtmosphereType.VACUUM && world.func_180495_p(bpos).func_185904_a() == Material.field_151586_h && world.func_180495_p(bpos).func_177230_c() instanceof IFluidBlock && (fluidblock = (IFluidBlock)world.func_180495_p(bpos).func_177230_c()).getFluid().isGaseous()) {
                world.func_175698_g(bpos);
            }
            if ((handler.getAtmosphereType(bpos) == AtmosphereType.SUPERHEATED || handler.getAtmosphereType(bpos) == AtmosphereType.SUPERHEATEDNOO2 || handler.getAtmosphereType(bpos) == AtmosphereType.VERYHOT || handler.getAtmosphereType(bpos) == AtmosphereType.VERYHOTNOO2) && world.func_180495_p(bpos).func_185904_a() == Material.field_151586_h) {
                world.func_175698_g(bpos);
            }
            List<AreaBlob> nearbyBlobs = handler.getBlobWithinRadius(pos, MAX_BLOB_RADIUS);
            for (AreaBlob blob : nearbyBlobs) {
                if (!((double)blob.getBlobMaxRadius() > pos.getDistance(blob.getRootPosition()))) continue;
                if (world.func_175623_d(bpos)) {
                    handler.onBlockRemove(pos);
                    continue;
                }
                if (blob.contains(pos) && !blob.isPositionAllowed(world, pos, nearbyBlobs)) {
                    blob.removeBlock(pos);
                    continue;
                }
                if (!blob.contains(blob.getRootPosition())) {
                    blob.addBlock(blob.getRootPosition(), nearbyBlobs);
                    continue;
                }
                if (blob.contains(pos) || !blob.isPositionAllowed(world, pos, nearbyBlobs)) continue;
                blob.addBlock(pos, nearbyBlobs);
            }
        }
    }

    @Nonnull
    protected List<AreaBlob> getBlobWithinRadius(@Nonnull HashedBlockPosition pos, int radius) {
        LinkedList<AreaBlob> list = new LinkedList<AreaBlob>();
        for (AreaBlob blob : this.blobs.values()) {
            if (!(blob.getRootPosition().getDistance(pos) - (double)radius <= 0.0)) continue;
            list.add(blob);
        }
        return list;
    }

    @Nullable
    public static AtmosphereHandler getOxygenHandler(int dimNumber) {
        return dimensionOxygen.get(dimNumber);
    }

    public void registerBlob(@Nonnull IBlobHandler handler, BlockPos pos) {
        AreaBlob blob = this.blobs.get(handler);
        if (blob == null) {
            blob = new AtmosphereBlob(handler);
            this.blobs.put(handler, blob);
            blob.setData(AtmosphereType.PRESSURIZEDAIR);
        }
    }

    public void registerBlob(@Nonnull IBlobHandler handler, BlockPos pos, @Nonnull AreaBlob blob2) {
        AreaBlob blob = this.blobs.get(handler);
        if (blob == null) {
            blob = blob2;
            this.blobs.put(handler, blob);
            blob.setData(AtmosphereType.PRESSURIZEDAIR);
        }
    }

    public void unregisterBlob(@Nonnull IBlobHandler handler) {
        this.blobs.remove(handler);
    }

    public void clearBlob(@Nonnull IBlobHandler handler) {
        if (this.blobs.containsKey(handler)) {
            this.blobs.get(handler).clearBlob();
        }
    }

    public void addBlock(@Nonnull IBlobHandler handler, int x, int y, int z) {
        this.addBlock(handler, new HashedBlockPosition(x, y, z));
    }

    public boolean addBlock(@Nonnull IBlobHandler handler, @Nonnull HashedBlockPosition pos) {
        AreaBlob blob = this.blobs.get(handler);
        blob.addBlock(pos, this.getBlobWithinRadius(pos, MAX_BLOB_RADIUS));
        return !blob.getLocations().isEmpty();
    }

    @Nonnull
    public IAtmosphere getAtmosphereType(@Nonnull BlockPos pos2) {
        if (ARConfiguration.getCurrentConfig().enableOxygen) {
            HashedBlockPosition pos = new HashedBlockPosition(pos2);
            for (AreaBlob blob : this.blobs.values()) {
                IAtmosphere atmosphere;
                if (!blob.contains(pos) || (atmosphere = (IAtmosphere)blob.getData()) == null) continue;
                return atmosphere;
            }
            return this.getDefaultAtmosphereType();
        }
        return AtmosphereType.AIR;
    }

    @Nonnull
    public IAtmosphere getDefaultAtmosphereType() {
        return DimensionManager.getInstance().getDimensionProperties(this.dimId).getAtmosphere();
    }

    @Nullable
    public IAtmosphere getAtmosphereType(@Nonnull Entity entity) {
        if (ARConfiguration.getCurrentConfig().enableOxygen) {
            HashedBlockPosition pos = new HashedBlockPosition((int)Math.floor(entity.field_70165_t), (int)Math.ceil(entity.field_70163_u), (int)Math.floor(entity.field_70161_v));
            for (AreaBlob blob : this.blobs.values()) {
                if (!blob.contains(pos)) continue;
                return (IAtmosphere)blob.getData();
            }
            return DimensionManager.getInstance().getDimensionProperties(this.dimId).getAtmosphere();
        }
        return AtmosphereType.AIR;
    }

    public int getAtmospherePressure(@Nonnull Entity entity) {
        if (ARConfiguration.getCurrentConfig().enableOxygen) {
            HashedBlockPosition pos = new HashedBlockPosition((int)Math.floor(entity.field_70165_t), (int)Math.ceil(entity.field_70163_u), (int)Math.floor(entity.field_70161_v));
            for (AreaBlob blob : this.blobs.values()) {
                if (!blob.contains(pos) || !(blob instanceof AtmosphereBlob)) continue;
                return ((AtmosphereBlob)blob).getPressure();
            }
        }
        return -1;
    }

    public boolean canEntityBreathe(@Nonnull EntityLiving entity) {
        if (ARConfiguration.getCurrentConfig().enableOxygen) {
            HashedBlockPosition pos = new HashedBlockPosition((int)Math.floor(entity.field_70165_t), (int)Math.ceil(entity.field_70163_u), (int)Math.floor(entity.field_70161_v));
            for (AreaBlob blob : this.blobs.values()) {
                IAtmosphere atmosphere = (IAtmosphere)blob.getData();
                if (!blob.contains(pos) || atmosphere == null || !atmosphere.isImmune((EntityLivingBase)entity)) continue;
                return true;
            }
            return DimensionManager.getInstance().getDimensionProperties(this.dimId).getAtmosphere().isImmune((EntityLivingBase)entity);
        }
        return true;
    }

    public int getBlobSize(@Nonnull IBlobHandler handler) {
        return this.blobs.get(handler).getBlobSize();
    }

    public void setAtmosphereType(@Nonnull IBlobHandler handler, @Nonnull IAtmosphere data) {
        this.blobs.get(handler).setData(data);
    }

    @Nonnull
    public IAtmosphere getAtmosphereType(@Nonnull IBlobHandler handler) {
        if (ARConfiguration.getCurrentConfig().enableOxygen) {
            IAtmosphere atmosphere = (IAtmosphere)this.blobs.get(handler).getData();
            if (atmosphere != null) {
                return atmosphere;
            }
            return this.getDefaultAtmosphereType();
        }
        return AtmosphereType.AIR;
    }
}

