/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.utility;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.dave.bonsaitrees.api.BonsaiIntegration;
import org.dave.bonsaitrees.api.IBonsaiIntegration;
import org.dave.bonsaitrees.utility.Logz;

public class AnnotatedInstanceUtil {
    private AnnotatedInstanceUtil() {
    }

    public static List<IBonsaiIntegration> getBonsaiIntegrations(ASMDataTable asmDataTable) {
        return AnnotatedInstanceUtil.getInstances(asmDataTable, BonsaiIntegration.class, IBonsaiIntegration.class);
    }

    private static <T> List<T> getInstances(ASMDataTable asmDataTable, Class annotationClass, Class<T> instanceClass) {
        String annotationClassName = annotationClass.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        ArrayList<T> instances = new ArrayList<T>();
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                String requiredMod;
                Map annotationInfo = asmData.getAnnotationInfo();
                if (annotationInfo.containsKey("mod") && (requiredMod = (String)annotationInfo.get("mod")).length() > 0 && !Loader.isModLoaded((String)requiredMod)) continue;
                Class<?> asmClass = Class.forName(asmData.getClassName());
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                T instance = asmInstanceClass.newInstance();
                instances.add(instance);
            }
            catch (ClassNotFoundException e) {
                Logz.error("Failed to load: {}", asmData.getClassName(), e);
            }
            catch (IllegalAccessException e) {
                Logz.error("Failed to load: {}", asmData.getClassName(), e);
            }
            catch (InstantiationException e) {
                Logz.error("Failed to load: {}", asmData.getClassName(), e);
            }
            catch (ExceptionInInitializerError e) {
                Logz.error("Failed to load: {}", asmData.getClassName(), e);
            }
        }
        return instances;
    }
}

