/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.transformers;

import com.endertech.minecraft.forge.coremod.ForgeClassTransformer;
import com.endertech.minecraft.forge.coremod.InstructList;
import com.endertech.minecraft.forge.coremod.descriptors.Classes;
import com.endertech.minecraft.forge.coremod.descriptors.Descriptor;
import com.endertech.minecraft.forge.coremod.descriptors.MethodDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Types;
import com.endertech.minecraft.forge.coremod.names.ClassName;
import com.endertech.minecraft.forge.coremod.signatures.FieldSignature;
import com.endertech.minecraft.forge.coremod.signatures.MethodSignature;
import com.endertech.minecraft.mods.adpother.transformers.Handlers;
import org.objectweb.asm.tree.MethodInsnNode;

public class ImmersivePetroleum {
    private static final String COMMON_PATH = "flaxbeard/immersivepetroleum/common/";

    public static class PortableGenerator
    extends ForgeClassTransformer {
        private final String className = "flaxbeard/immersivepetroleum/common/blocks/metal/TileEntityGasGenerator";
        private final MethodSignature targetMethod = MethodSignature.I_TICKABLE_UPDATE.with("flaxbeard/immersivepetroleum/common/blocks/metal/TileEntityGasGenerator");
        private final MethodSignature targetInstruct;

        public PortableGenerator() {
            this.targetInstruct = MethodSignature.of((ClassName)Classes.FLUID_TANK.name, (String)"drain", (MethodDescriptor)MethodDescriptor.of((Classes)Classes.FLUID_STACK).withParameters(new Descriptor[]{Classes.FLUID_STACK.descriptor, Types.BOOLEAN.descriptor}));
        }

        protected MethodSignature getTargetMethod() {
            return this.targetMethod;
        }

        protected MethodSignature getHandler() {
            return Handlers.ON_FLUID_FUEL_STACK_BURNED_BY_TILE;
        }

        protected boolean isProperInstruction(MethodInsnNode instruct) {
            return this.targetInstruct.complyWith(instruct);
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperInstruct) {
            return false;
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.dup().loadThis().swap().invokeStatic(this.getHandler()).insertAfter();
        }
    }

    public static class Motorboat
    extends ForgeClassTransformer {
        private final String classDoSync = "flaxbeard/immersivepetroleum/common/network/ConsumeBoatFuelPacket$DoSync";
        private final String classSpeedboat = "flaxbeard/immersivepetroleum/common/entity.EntitySpeedboat";
        private final MethodSignature targetMethod = MethodSignature.of((String)"flaxbeard/immersivepetroleum/common/network/ConsumeBoatFuelPacket$DoSync", (String)"run", (MethodDescriptor)MethodDescriptor.VOID);
        private final MethodSignature targetInstruct = MethodSignature.of((String)"flaxbeard/immersivepetroleum/common/entity.EntitySpeedboat", (String)"setContainedFluid", (MethodDescriptor)MethodDescriptor.VOID.withParameters(new Classes[]{Classes.FLUID_STACK}));
        private final FieldSignature amount;

        public Motorboat() {
            this.amount = FieldSignature.of((String)"flaxbeard/immersivepetroleum/common/network/ConsumeBoatFuelPacket$DoSync", (String)"amount", (Descriptor)Types.INT.descriptor);
        }

        protected MethodSignature getTargetMethod() {
            return this.targetMethod;
        }

        protected MethodSignature getHandler() {
            return Handlers.ON_FLUID_FUEL_STACK_BURNED_BY_ENTITY_AMOUNT;
        }

        protected boolean isProperInstruction(MethodInsnNode instruct) {
            return this.targetInstruct.complyWith(instruct);
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperInstruct) {
            return false;
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.loadObjFrom(2, "boat").loadObjFrom(3, "fluid").loadThis().getField(this.amount).invokeStatic(this.getHandler()).insertAfter();
        }
    }
}

