/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.transformers;

import com.endertech.minecraft.forge.coremod.InstructList;
import com.endertech.minecraft.forge.coremod.descriptors.ClassDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Classes;
import com.endertech.minecraft.forge.coremod.descriptors.Descriptor;
import com.endertech.minecraft.forge.coremod.descriptors.MethodDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Types;
import com.endertech.minecraft.forge.coremod.signatures.MethodSignature;
import com.endertech.minecraft.mods.adpother.transformers.Abstract;
import com.endertech.minecraft.mods.adpother.transformers.Handlers;
import java.lang.reflect.Method;
import net.minecraft.tileentity.TileEntity;
import org.objectweb.asm.tree.MethodInsnNode;

public class Gregtech {
    private static final String metaTileClassName = "gregtech.api.metatileentity.MetaTileEntity";
    private static final MethodSignature getMetaTile = MethodSignature.of((String)"gregtech.api.metatileentity.MTETrait", (String)"getMetaTileEntity", (MethodDescriptor)MethodDescriptor.of((Descriptor)ClassDescriptor.from((String)"gregtech.api.metatileentity.MetaTileEntity")));
    private static final MethodSignature getTile = MethodSignature.of((String)"com.endertech.minecraft.mods.adpother.transformers.Gregtech", (String)"getTile", (MethodDescriptor)MethodDescriptor.of((Descriptor)Classes.TILE_ENTITY.descriptor).withParameters(new Classes[]{Classes.OBJECT}));
    private static Method holder;

    public static final TileEntity getTile(Object obj) {
        if (obj instanceof TileEntity) {
            return (TileEntity)obj;
        }
        try {
            if (holder == null) {
                holder = Class.forName(metaTileClassName).getDeclaredMethod("getHolder", new Class[0]);
                holder.setAccessible(true);
            }
            return (TileEntity)holder.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class BoilerRecipeLogic
    extends MetaLiquidFuelMachine {
        private final String className = "gregtech.api.capability.impl.BoilerRecipeLogic";
        private final MethodSignature targetMethod = MethodSignature.of((String)"gregtech.api.capability.impl.BoilerRecipeLogic", (String)"trySearchNewRecipe", (MethodDescriptor)MethodDescriptor.VOID);
        private int insnNumber = 0;
        private boolean solidFuel = false;

        protected MethodSignature getTargetMethod() {
            return this.targetMethod;
        }

        @Override
        protected boolean isProperInstruction(MethodInsnNode node) {
            if (MethodSignature.ITEM_STACK_SHRINK.complyWith(node)) {
                this.solidFuel = true;
                return true;
            }
            if (super.isProperInstruction(node)) {
                this.solidFuel = false;
                ++this.insnNumber;
                if (this.insnNumber > 1) {
                    return true;
                }
            }
            return false;
        }

        @Override
        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperNode) {
            return true;
        }

        @Override
        protected void injectInstructions(InstructList instructions) {
            if (this.solidFuel) {
                instructions.loadThis().invokeVirtual(getMetaTile).invokeStatic(getTile).dupValue3().invokeStatic(Handlers.ON_FUEL_BURNED_BY_TILE).insertBefore();
            } else {
                instructions.loadThis().invokeVirtual(getMetaTile).invokeStatic(getTile).dupValue2().invokeStatic(this.getHandler()).insertAfter();
            }
        }
    }

    public static class FuelRecipeLogic
    extends MetaLiquidFuelMachine {
        private final String className = "gregtech.api.capability.impl.FuelRecipeLogic";
        private final MethodSignature targetMethod = MethodSignature.of((String)"gregtech.api.capability.impl.FuelRecipeLogic", (String)"tryAcquireNewRecipe", (MethodDescriptor)MethodDescriptor.VOID);

        protected MethodSignature getTargetMethod() {
            return this.targetMethod;
        }

        @Override
        protected void injectInstructions(InstructList instructions) {
            instructions.loadThis().invokeVirtual(getMetaTile).invokeStatic(getTile).dupValue2().invokeStatic(this.getHandler()).insertAfter();
        }
    }

    public static class SteamLavaBoiler
    extends MetaLiquidFuelMachine {
        private final String className = "gregtech.common.metatileentities.steam.boiler.SteamLavaBoiler";
        private final MethodSignature targetMethod = MethodSignature.of((String)"gregtech.common.metatileentities.steam.boiler.SteamLavaBoiler", (String)"tryConsumeNewFuel", (MethodDescriptor)MethodDescriptor.VOID);

        protected MethodSignature getTargetMethod() {
            return this.targetMethod;
        }

        @Override
        protected boolean isProperInstruction(MethodInsnNode node) {
            return MethodSignature.FLUID_TANK_DRAIN.complyWith(node);
        }
    }

    public static class SteamCoalBoiler
    extends MetaSolidFuelMachine {
        private final String className = "gregtech.common.metatileentities.steam.boiler.SteamCoalBoiler";
        private final MethodSignature targetMethod = MethodSignature.of((String)"gregtech.common.metatileentities.steam.boiler.SteamCoalBoiler", (String)"tryConsumeNewFuel", (MethodDescriptor)MethodDescriptor.VOID);
        private final MethodSignature targetNode = MethodSignature.of((String)"net.minecraftforge.items.IItemHandlerModifiable", (String)"extractItem", (MethodDescriptor)MethodDescriptor.of((Classes)Classes.ITEM_STACK).withParameters(new Types[]{Types.INT, Types.INT, Types.BOOLEAN}));
        private int insnNumber = 0;

        protected MethodSignature getTargetMethod() {
            return this.targetMethod;
        }

        @Override
        protected boolean isProperInstruction(MethodInsnNode node) {
            if (this.targetNode.complyWith(node)) {
                ++this.insnNumber;
                if (this.insnNumber == 2) {
                    return true;
                }
            }
            return false;
        }

        @Override
        protected void injectInstructions(InstructList instructions) {
            instructions.loadThis().invokeStatic(getTile).dupValue2().invokeStatic(this.getHandler()).insertAfter();
        }
    }

    public static class LargeBoilerLiquidFuel
    extends MetaLiquidFuelMachine {
        private static final String className = "gregtech.common.metatileentities.multi.MetaTileEntityLargeBoiler";
        private static final MethodSignature targetMethod = MethodSignature.of((String)"gregtech.common.metatileentities.multi.MetaTileEntityLargeBoiler", (String)"setupRecipeAndConsumeInputs", (MethodDescriptor)MethodDescriptor.of((Types)Types.INT));
        private int insnNumber = 0;

        protected MethodSignature getTargetMethod() {
            return targetMethod;
        }

        @Override
        protected boolean isProperInstruction(MethodInsnNode node) {
            if (super.isProperInstruction(node)) {
                ++this.insnNumber;
                if (this.insnNumber > 1) {
                    return true;
                }
            }
            return false;
        }

        @Override
        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperNode) {
            return true;
        }
    }

    public static class LargeBoilerSolidFuel
    extends MetaSolidFuelMachine {
        private static final String className = "gregtech.common.metatileentities.multi.MetaTileEntityLargeBoiler";
        private static final MethodSignature targetMethod = MethodSignature.of((String)"gregtech.common.metatileentities.multi.MetaTileEntityLargeBoiler", (String)"setupRecipeAndConsumeInputs", (MethodDescriptor)MethodDescriptor.of((Types)Types.INT));

        protected MethodSignature getTargetMethod() {
            return targetMethod;
        }
    }

    public static class PrimitiveBlastFurnace
    extends MetaSolidFuelMachine {
        private final String className = "gregtech.common.metatileentities.multi.MetaTileEntityPrimitiveBlastFurnace";
        private final MethodSignature targetMethod = MethodSignature.of((String)"gregtech.common.metatileentities.multi.MetaTileEntityPrimitiveBlastFurnace", (String)"tryPickNewRecipe", (MethodDescriptor)MethodDescriptor.of((Types)Types.BOOLEAN));
        private int insnNumber = 0;

        @Override
        protected boolean isProperInstruction(MethodInsnNode node) {
            if (super.isProperInstruction(node)) {
                ++this.insnNumber;
                if (this.insnNumber > 1) {
                    return true;
                }
            }
            return false;
        }

        @Override
        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperNode) {
            return true;
        }

        protected MethodSignature getTargetMethod() {
            return this.targetMethod;
        }
    }

    public static class CokeOven
    extends MetaSolidFuelMachine {
        private final String className = "gregtech.common.metatileentities.multi.MetaTileEntityCokeOven";
        private final MethodSignature targetMethod = MethodSignature.of((String)"gregtech.common.metatileentities.multi.MetaTileEntityCokeOven", (String)"tryPickNewRecipe", (MethodDescriptor)MethodDescriptor.of((Types)Types.BOOLEAN));

        protected MethodSignature getTargetMethod() {
            return this.targetMethod;
        }
    }

    static abstract class MetaLiquidFuelMachine
    extends Abstract.LiquidFuelMachine {
        private final MethodSignature targetNode = MethodSignature.FLUID_TANK_DRAIN.with("net.minecraftforge.fluids.IFluidTank");

        MetaLiquidFuelMachine() {
        }

        @Override
        protected boolean isProperInstruction(MethodInsnNode node) {
            return this.targetNode.complyWith(node);
        }

        @Override
        protected void injectInstructions(InstructList instructions) {
            instructions.loadThis().invokeStatic(getTile).dupValue2().invokeStatic(this.getHandler()).insertAfter();
        }
    }

    static abstract class MetaSolidFuelMachine
    extends Abstract.SolidFuelMachine {
        MetaSolidFuelMachine() {
        }

        @Override
        protected void injectInstructions(InstructList instructions) {
            instructions.loadThis().invokeStatic(getTile).dupValue3().invokeStatic(this.getHandler()).insertBefore();
        }
    }
}

