/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.transformers;

import com.endertech.minecraft.forge.coremod.ForgeClassTransformer;
import com.endertech.minecraft.forge.coremod.InstructList;
import com.endertech.minecraft.forge.coremod.descriptors.Classes;
import com.endertech.minecraft.forge.coremod.descriptors.Descriptor;
import com.endertech.minecraft.forge.coremod.descriptors.MethodDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Types;
import com.endertech.minecraft.forge.coremod.signatures.MethodSignature;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.world.WorldBounds;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.transformers.Handlers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import org.objectweb.asm.tree.MethodInsnNode;

public class Galacticraft {

    public static class Buggy
    extends EntityBase {
        @Override
        protected String getClassName() {
            return "micdoodle8.mods.galacticraft.core.entities.EntityBuggy";
        }
    }

    public static class AutoRocket
    extends EntityBase {
        public static float rate = 1.0f;

        public static void handle(Entity entity, @Nullable FluidStack stack) {
            if (stack == null) {
                return;
            }
            AxisAlignedBB aabb = ForgeEntity.getBB((Entity)entity);
            WorldBounds bounds = WorldBounds.from((BlockPos)new BlockPos(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c), (BlockPos)new BlockPos(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f)).extend(1);
            BlockPos pos = new BlockPos(bounds.getX().randomBetween().intValue(), bounds.getY().randomBetween().intValue(), bounds.getZ().randomBetween().intValue());
            WorldData.onFuelBurned(entity, pos, stack.getFluid(), Math.round(100.0f * rate));
        }

        @Override
        protected String getClassName() {
            return "micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket";
        }

        @Override
        protected MethodSignature getHandler() {
            return this.getDefaultHandlerWith(MethodDescriptor.VOID.withParameters(new Descriptor[]{Classes.ENTITY.descriptor, Classes.FLUID_STACK.descriptor}));
        }

        @Override
        protected void injectInstructions(InstructList instructions) {
            instructions.dup().loadThis().swap().invokeStatic(this.getHandler()).insertAfter();
        }
    }

    static abstract class EntityBase
    extends ForgeClassTransformer {
        private final MethodSignature targetMethod = MethodSignature.of((String)this.getClassName(), (String)"removeFuel", (MethodDescriptor)MethodDescriptor.of((Classes)Classes.FLUID_STACK).withParameters(new Types[]{Types.INT}));

        EntityBase() {
        }

        protected abstract String getClassName();

        protected MethodSignature getTargetMethod() {
            return this.targetMethod;
        }

        protected MethodSignature getHandler() {
            return Handlers.ON_FLUID_FUEL_STACK_BURNED_BY_ENTITY;
        }

        public boolean isCompatibilityMode() {
            return true;
        }

        protected boolean isProperInstruction(MethodInsnNode instruct) {
            return MethodSignature.FLUID_TANK_DRAIN.complyWith(instruct);
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperInstruct) {
            return false;
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.dup().loadThis().swap().invokeStatic(this.getHandler()).insertAfter();
        }
    }
}

