/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.transformers;

import com.endertech.minecraft.forge.coremod.ForgeClassTransformer;
import com.endertech.minecraft.forge.coremod.InstructList;
import com.endertech.minecraft.forge.coremod.descriptors.Classes;
import com.endertech.minecraft.forge.coremod.descriptors.MethodDescriptor;
import com.endertech.minecraft.forge.coremod.names.ClassName;
import com.endertech.minecraft.forge.coremod.signatures.MethodSignature;
import com.endertech.minecraft.mods.adpother.transformers.Handlers;
import org.objectweb.asm.tree.MethodInsnNode;

public class Abstract {

    protected static abstract class RandomTickTransformer
    extends ForgeClassTransformer {
        protected final MethodSignature targetMethod = MethodSignature.of((ClassName)ClassName.from((String)this.getClassName()), (String)"randomTick", (String)"func_180645_a", (MethodDescriptor)MethodDescriptor.VOID.withParameters(new Classes[]{Classes.WORLD, Classes.BLOCK_POS, Classes.IBLOCK_STATE, Classes.RANDOM}));

        protected RandomTickTransformer() {
        }

        protected abstract String getClassName();

        protected MethodSignature getTargetMethod() {
            return this.targetMethod;
        }

        protected MethodSignature getHandler() {
            return Handlers.ON_BLOCK_RANDOM_TICK;
        }

        public boolean isCompatibilityMode() {
            return true;
        }

        protected boolean isProperInstruction(MethodInsnNode instruct) {
            return true;
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperInstruct) {
            return false;
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.loadObjFrom(1, "world").loadObjFrom(2, "pos").invokeStatic(this.getHandler()).pop().insertAfter();
        }
    }

    protected static abstract class LiquidFuelMachine
    extends ForgeClassTransformer {
        protected LiquidFuelMachine() {
        }

        protected boolean isProperInstruction(MethodInsnNode instruct) {
            return MethodSignature.FLUID_TANK_DRAIN.complyWith(instruct);
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperNode) {
            return false;
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.dup().loadThis().swap().invokeStatic(this.getHandler()).insertAfter();
        }

        protected MethodSignature getHandler() {
            return Handlers.ON_FLUID_FUEL_STACK_BURNED_BY_TILE;
        }

        public boolean isCompatibilityMode() {
            return true;
        }
    }

    protected static abstract class SolidFuelMachine
    extends ForgeClassTransformer {
        protected SolidFuelMachine() {
        }

        protected boolean isProperInstruction(MethodInsnNode node) {
            return MethodSignature.ITEM_STACK_SHRINK.complyWith(node);
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperNode) {
            return false;
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.loadThis().dupValue3().invokeStatic(this.getHandler()).insertBefore();
        }

        protected MethodSignature getHandler() {
            return Handlers.ON_FUEL_BURNED_BY_TILE;
        }

        public boolean isCompatibilityMode() {
            return true;
        }
    }
}

