/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.renders;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.ForgeRendering;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.coremod.hooks.RenderItemHook;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.items.Aerometer;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.awt.Color;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class AerometerRender
extends RenderItemHook {
    static final ColorARGB COLOR_RED = ColorARGB.from((Color)Color.RED);

    public static void handle(ItemStack stack) {
        AerometerRender.renderItem(stack, 1.0);
    }

    public static void renderItem(ItemStack stack, double scale) {
        if (ForgeItem.isBroken((ItemStack)stack)) {
            return;
        }
        Entity carrier = Aerometer.findCarrierFor(stack);
        if (carrier == null) {
            return;
        }
        EntityPollution pollution = WorldData.getEntityPollution(carrier);
        ForgeRendering.MeterIndicators.beforeRender((float)0.08f);
        double offset = 0.001;
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)offset);
        for (Pollutant pollutant : pollution.getPollutants().collect(Collectors.toList())) {
            float factor = pollution.getInfluenceOf(pollutant).toFraction();
            ColorARGB color = pollutant.getColor();
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)offset);
            Needle.draw(color, factor, scale);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-offset));
            offset += 0.001;
        }
        if (pollution.hasExplosionRisk()) {
            ExplosionRiskIndicator.draw(COLOR_RED, scale);
        }
        ForgeRendering.MeterIndicators.afterRender();
    }

    static class Needle {
        private static final double WIDTH = 0.1;
        private static final double LENGTH = 0.35;
        public static final double OFFSET = 0.001;
        public static FloatBounds angle = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(180.0f));
        public static CommonMath.Angle minAngle = CommonMath.Angle.fromDegrees((double)180.0);
        public static CommonMath.Angle maxAngle = CommonMath.Angle.fromDegrees((double)0.0);

        Needle() {
        }

        @SideOnly(value=Side.CLIENT)
        public static void draw(ColorARGB color, float factor, double scale) {
            double degrees = angle.approxDown(factor).floatValue() - 90.0f;
            GL11.glRotated((double)degrees, (double)0.0, (double)0.0, (double)1.0);
            GL11.glColor4f((float)color.getRed().toFloat(), (float)color.getGreen().toFloat(), (float)color.getBlue().toFloat(), (float)color.getAlpha().toFloat());
            GL11.glBegin((int)7);
            GL11.glVertex3d((double)(-0.05 * scale), (double)(-0.06999999999999999 * scale), (double)0.0);
            GL11.glVertex3d((double)(0.05 * scale), (double)(-0.06999999999999999 * scale), (double)0.0);
            GL11.glVertex3d((double)(0.05 * scale), (double)(0.35 * scale), (double)0.0);
            GL11.glVertex3d((double)(-0.05 * scale), (double)(0.35 * scale), (double)0.0);
            GL11.glEnd();
            GL11.glRotated((double)(-degrees), (double)0.0, (double)0.0, (double)1.0);
        }
    }

    static class ExplosionRiskIndicator {
        ExplosionRiskIndicator() {
        }

        @SideOnly(value=Side.CLIENT)
        public static void draw(ColorARGB color, double scale) {
            double size = 0.3 * scale;
            GlStateManager.func_179131_c((float)color.getRed().toFloat(), (float)color.getGreen().toFloat(), (float)color.getBlue().toFloat(), (float)color.getAlpha().toFloat());
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder buf = tess.func_178180_c();
            buf.func_181668_a(4, DefaultVertexFormats.field_181707_g);
            buf.func_181662_b(0.0, size, 0.0).func_187315_a(0.5, 0.0).func_181675_d();
            buf.func_181662_b(-size, size / 2.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            buf.func_181662_b(size, size / 2.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            tess.func_78381_a();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

