/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.mods.adpother.Main;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.pollution.IStorage;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IStorageItem
extends IStorage<ItemStack> {
    @Override
    default public IStorage.Content getContent(ItemStack storage) {
        NBTTagCompound compound = storage.func_77978_p();
        if (compound != null) {
            return IStorage.Content.from(compound);
        }
        return new IStorage.Content(0);
    }

    @Override
    default public void onContentChanged(IStorage.Content content, ItemStack storage) {
        ForgeItem.ensureHasNBT((ItemStack)storage);
        NBTTagCompound compound = storage.func_77978_p();
        if (compound != null) {
            content.writeToNBT(compound);
        }
    }

    @SideOnly(value=Side.CLIENT)
    default public void addInformation(ItemStack stack, World world, List<String> tooltip) {
        IStorage.Content content = this.getContent(stack);
        for (Pollutant pollutant : Main.getPollutants().getAll()) {
            if (!content.hasFilterFor(pollutant)) continue;
            Percentage fullness = content.getFullnessPercentageFor(pollutant);
            tooltip.add(pollutant.getTextColor() + pollutant.func_149732_F() + ": " + fullness.toColoredText());
        }
        if (ForgeMain.isDebugMode()) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.storage_item.capacity", (Object[])new Object[]{TextFormatting.WHITE}) + ": " + content.getCapacity());
        }
    }
}

