/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.minecraft.forge.configs.ForgeNBT;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.pollution.PollutionInfo;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class AbstractPollution {
    protected Map<Pollutant<?>, PollutionInfo> infoForPollutant = new ConcurrentHashMap();

    public Stream<PollutionInfo> getInfos() {
        return this.infoForPollutant.values().stream();
    }

    public boolean isEmpty() {
        return !this.getInfos().anyMatch(info -> !info.isEmpty());
    }

    @Nonnull
    public PollutionInfo getOrCreateInfoFor(Pollutant<?> pollutant) {
        PollutionInfo info = this.infoForPollutant.get(pollutant);
        if (info == null) {
            info = new PollutionInfo(pollutant);
            this.infoForPollutant.put(pollutant, info);
        }
        return info;
    }

    public Optional<PollutionInfo> getInfoFor(Pollutant<?> pollutant) {
        return Optional.ofNullable(this.infoForPollutant.get(pollutant));
    }

    public void readFrom(NBTTagCompound compound) {
        if (compound.func_74764_b(Tags.POLLUTANTS_LIST.name())) {
            this.infoForPollutant.clear();
            NBTTagList list = compound.func_150295_c(Tags.POLLUTANTS_LIST.name(), ForgeNBT.Types.COMPOUND.id);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                PollutionInfo info = new PollutionInfo(null).readFrom(tag);
                if (info.isEmpty()) continue;
                this.infoForPollutant.put(info.getPollutant(), info);
            }
        }
    }

    public void writeTo(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        this.getInfos().filter(info -> !info.isEmpty()).forEach(info -> {
            NBTTagCompound tag = info.writeTo(new NBTTagCompound());
            list.func_74742_a((NBTBase)tag);
        });
        compound.func_74782_a(Tags.POLLUTANTS_LIST.name(), (NBTBase)list);
    }

    protected static enum Tags {
        POLLUTANTS_LIST;

    }
}

