/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.items;

import baubles.api.BaubleType;
import baubles.api.render.IRenderBauble;
import com.endertech.common.CommonMath;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.api.IBaubleWear;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.items.ChestWearItem;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.entities.EntityPollutant;
import com.endertech.minecraft.mods.adpother.init.Materials;
import com.endertech.minecraft.mods.adpother.init.Pollutants;
import com.endertech.minecraft.mods.adpother.pollution.IStorage;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="com.endertech.minecraft.forge.api.IBaubleWear", modid="baubles", striprefs=true)
public class VacuumBag
extends ChestWearItem
implements IStorageItem,
IBaubleWear {
    private final int capacity;

    public VacuumBag(ForgeMod mod, UnitConfig config, Materials material) {
        super(mod, config, material.func_176610_l(), CreativeTabs.field_78040_i, 64, UnitId.from((String)"leather"), SoundEvents.field_187728_s);
        this.capacity = ForgeConfig.getInt((ForgeConfig)config, (String)this.getUnitCategory(), (String)"capacity", (int)material.capacity, (IntBounds)IntBounds.INTEGER_POSITIVE, (String)"Defines the maximum capacity of the bag.");
        this.addCraftingRecipe("122 545 333", 1, new String[]{"slimeball", "wool:*", "leather", "leather_chestplate", material.getDictName()});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        this.addInformation(stack, world, tooltip);
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        World world = entity.func_130014_f_();
        if (this.isServerSide(world) && entity instanceof EntityPollutant) {
            EntityPollutant carrier = (EntityPollutant)entity;
            Pollutant<?> pollutant = carrier.getPollutant();
            if (carrier.spend()) {
                pollutant.func_176226_b(world, carrier.func_180425_c(), pollutant.func_176223_P(), 0);
            }
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return state.func_177230_c() instanceof Pollutant;
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        this.installFiltersFor(stack, new Pollutant[]{Pollutants.BuiltIn.SULFUR.get()});
    }

    @Override
    public int fill(ItemStack storage, Pollutant<?> pollutant, int amount) {
        if (VacuumBag.isBroken((ItemStack)storage)) {
            return 0;
        }
        IStorage.Content content = this.getContent(storage);
        float gradeFactor = content.getFullnessPercentageFor(pollutant).getGrade().ordinal() + 1;
        float wearoutChance = 0.05f * gradeFactor;
        if (CommonMath.Random.result((float)wearoutChance)) {
            ForgeItem.damageItem((int)1, (ItemStack)storage, null, (boolean)false);
        }
        Percentage wearout = this.getWearoutPercentage(storage);
        boolean leak = false;
        if (wearout.getGrade() == Percentage.Grade.HIGH) {
            float chance = Percentage.HUNDRED.getValue() - wearout.getGrade().threshold;
            float probability = 1.0f / Math.max(1.0f, chance);
            leak = CommonMath.Random.result((float)probability);
        }
        if (leak) {
            return 0;
        }
        return IStorageItem.super.fill(storage, pollutant, amount);
    }

    public BaubleType getBaubleType(ItemStack stack) {
        return BaubleType.BODY;
    }

    @SideOnly(value=Side.CLIENT)
    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer player, IRenderBauble.RenderType renderType, float partialTicks) {
        if (renderType != IRenderBauble.RenderType.BODY) {
            return;
        }
        GlStateManager.func_179094_E();
        this.translateForChest(player);
        this.renderItemOn((EntityLivingBase)player, stack, ItemCameraTransforms.TransformType.HEAD);
        GlStateManager.func_179121_F();
    }

    @Override
    public int getInitialCapacity(ItemStack storage) {
        return this.capacity;
    }
}

