/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.items;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.items.GlassMeter;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.threads.ForgeCacheCleaner;
import com.endertech.minecraft.forge.units.UnitVariant;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Aerometer
extends GlassMeter {
    public static final float THICKNESS = 0.08f;
    private Cleaner cleaner;

    public Aerometer(ForgeMod mod, UnitConfig config) {
        super(mod, config, "", CreativeTabs.field_78040_i, 4, EntityEquipmentSlot.OFFHAND, TextFormatting.GREEN);
        this.addCraftingRecipe("161 232 454", 1, new String[]{"repeater", "logWood", "compass", "comparator", "stick", "paneGlass"});
        this.setUnitVariants(Variants.class);
    }

    @Nullable
    public static Entity findCarrierFor(ItemStack stack) {
        Entity carrier = null;
        if (stack.func_77973_b() instanceof Aerometer) {
            Aerometer meter = (Aerometer)stack.func_77973_b();
            carrier = (Entity)meter.carriers.get(stack);
        }
        return carrier;
    }

    public static List<ItemStack> findInInventoryOf(EntityPlayer player) {
        ArrayList<ItemStack> found = new ArrayList<ItemStack>();
        InventoryPlayer inventory = player.field_71071_by;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof Aerometer)) continue;
            found.add(stack);
        }
        return found;
    }

    public void onInit() {
        super.onInit();
    }

    @SideOnly(value=Side.CLIENT)
    public void onInitClient() {
    }

    public UnitVariant getVariantFor(ItemStack stack) {
        if (Aerometer.isBroken((ItemStack)stack)) {
            return this.getVariant((Object)Variants.BROKEN);
        }
        Entity carrier = Aerometer.findCarrierFor(stack);
        if (carrier != null) {
            EntityPollution pollution = WorldData.getEntityPollution(carrier);
            Percentage influence = pollution.getDominantPollutant(pollutant -> true).map(pollutant -> pollution.getInfluenceOf((Pollutant<?>)((Object)pollutant))).orElse(Percentage.ZERO);
            switch (influence.getGrade()) {
                case HIGH: {
                    return this.getVariant((Object)Variants.RED);
                }
                case MEDIUM: {
                    return this.getVariant((Object)Variants.YELLOW);
                }
                case LOW: {
                    return this.getVariant((Object)Variants.GREEN);
                }
            }
        }
        return this.getVariant((Object)Variants.NORMAL);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        this.updateCarrier(world, stack, entity);
    }

    public void updateCarrier(World world, ItemStack stack, Entity entity) {
        if (this.isClientSide(world)) {
            this.carriers.put(stack, entity);
            this.cleanUselessStacks();
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        this.updateCarrier(entityItem.field_70170_p, entityItem.func_92059_d(), (Entity)entityItem);
        return super.onEntityItemUpdate(entityItem);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        Entity carrier;
        if (Aerometer.notBroken((ItemStack)stack) && (carrier = Aerometer.findCarrierFor(stack)) != null) {
            EntityPollution pollution = WorldData.getEntityPollution(carrier);
            pollution.getInfos().map(info -> info.getPollutant()).forEach(pollutant -> tooltip.add(pollutant.getTextColor() + pollutant.func_149732_F() + ": " + pollution.getInfluenceOf((Pollutant<?>)((Object)pollutant)).toColoredText()));
        }
        if (ForgeMain.isDebugMode() && world != null) {
            tooltip.add("Debug:");
            tooltip.add("Spawned Entities: " + WorldData.getData(world).getPollutantEntityLimiter().getTotalAmount());
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    private void cleanUselessStacks() {
        if (this.cleaner == null || this.cleaner.isTimeToRun()) {
            this.cleaner = new Cleaner(CommonTime.Interval.seconds((double)10.0));
        }
    }

    public class Cleaner
    extends ForgeCacheCleaner {
        public Cleaner(CommonTime.Interval runInterval) {
            super(runInterval);
        }

        public void run() {
            Iterator iterator = Aerometer.this.carriers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                ItemStack stack = (ItemStack)entry.getKey();
                Entity entity = (Entity)entry.getValue();
                if (!stack.func_190926_b() && ForgeEntity.hasStack((Entity)entity, (ItemStack)stack)) continue;
                iterator.remove();
            }
        }
    }

    private static enum Variants implements IForgeEnum
    {
        NORMAL,
        BROKEN,
        GREEN,
        YELLOW,
        RED;


        public String func_176610_l() {
            return this.getLowerCase(this.name());
        }
    }
}

