/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.units.UnitsInit;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adpother.blocks.PollutedWater;
import com.endertech.minecraft.mods.adpother.init.Blocks;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fluids.IFluidBlock;

public class Fluids
extends UnitsInit<IFluidBlock> {
    public final PollutedWater pollutedWater;

    public Fluids(ForgeMod mod) {
        super(mod);
        this.pollutedWater = new PollutedWater(mod, this.createConfigFor(PollutedWater.class));
        this.add((Object)this.pollutedWater);
    }

    public static abstract class WaterChain
    extends WorldSearch.BlockChain {
        protected final int maxRadius;

        protected WaterChain(World world, BlockPos startPos, int maxRadius) {
            super(world, startPos, Math.round((float)Math.PI * (float)maxRadius * (float)maxRadius));
            this.maxRadius = maxRadius;
        }

        protected Collection<EnumFacing> getDirections() {
            return ForgeWorld.Direction.getShuffledHorizontals();
        }

        protected boolean isWithinMaxRadius(BlockPos pos) {
            return this.startPos.func_177951_i((Vec3i)pos) <= (double)(this.maxRadius * this.maxRadius);
        }

        protected boolean isValidPath(BlockPos pos) {
            if (this.lastUsedDirection == null) {
                return true;
            }
            if (!this.isWithinMaxRadius(pos)) {
                return false;
            }
            IBlockState state = this.world.func_180495_p(pos);
            Material material = state.func_185904_a();
            return material == Material.field_151586_h;
        }
    }

    static class SoilChain
    extends WorldSearch.BlockChain {
        private boolean affected = false;
        private final BlockPos top;

        public static SoilChain from(World world, BlockPos startPos, int maxLength, BlockPos topPos) {
            SoilChain chain = new SoilChain(world, startPos, maxLength, topPos);
            chain.build();
            return chain;
        }

        protected SoilChain(World world, BlockPos startPos, int maxLength, BlockPos topPos) {
            super(world, startPos, maxLength);
            this.top = topPos;
        }

        public boolean isAffected() {
            return this.affected;
        }

        protected Collection<EnumFacing> getDirections() {
            return ForgeWorld.Direction.getShuffledAll();
        }

        protected boolean isValidPath(BlockPos pos) {
            if (this.lastUsedDirection == null) {
                return true;
            }
            if (pos.func_177956_o() > this.top.func_177956_o()) {
                return false;
            }
            IBlockState state = this.world.func_180495_p(pos);
            Material material = state.func_185904_a();
            if (material == Material.field_151595_p) {
                return true;
            }
            return this.isValidBlock(pos);
        }

        protected boolean isValidBlock(BlockPos pos) {
            if (pos.func_177956_o() > this.top.func_177956_o()) {
                return false;
            }
            IBlockState state = this.world.func_180495_p(pos);
            Block block = state.func_177230_c();
            Material material = state.func_185904_a();
            if (material == Material.field_151578_c || material == Material.field_151577_b) {
                return true;
            }
            return block instanceof IPlantable || block instanceof IGrowable;
        }

        protected boolean onValidFound(BlockPos pos) {
            IBlockState state = this.world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block instanceof BlockGrass || block instanceof BlockFarmland) {
                this.affected = this.world.func_175656_a(pos, Blocks.PODZOL);
            } else if (state == Blocks.DIRT) {
                this.affected = this.world.func_175656_a(pos, Blocks.COARSE_DIRT);
            } else if (block instanceof IPlantable || block instanceof IGrowable) {
                this.affected = this.world.func_175698_g(pos);
            }
            return !this.affected;
        }
    }

    public static enum ToxicFluids {
        bio_diesel,
        biocrude,
        biodiesel,
        canola_methanol_mix,
        canola_oil,
        coal,
        creosote,
        creotheum,
        crude_oil,
        diesel,
        ender,
        ethanol,
        fire_water,
        fuel,
        gasoline,
        glycerin,
        heavy_oil,
        hootch,
        hot_crude,
        kerosene,
        light_oil,
        lubricant,
        methanol,
        napalm,
        naphtha,
        oil,
        oil_residue,
        petroil,
        petrol,
        petrotheum,
        plantoil,
        polluted_water,
        pyrotheum,
        redstone,
        refined_biofuel,
        refined_fuel,
        refined_oil,
        resin,
        rocket_fuel;

        private static final Map<String, ToxicFluids> NAME_LOOKUP;

        @Nullable
        public static ToxicFluids findBy(String name) {
            return NAME_LOOKUP.get(name);
        }

        @Nullable
        public static ToxicFluids findAt(World world, BlockPos pos) {
            Block block = world.func_180495_p(pos).func_177230_c();
            if (block instanceof IFluidBlock) {
                IFluidBlock fluidBlock = (IFluidBlock)block;
                String name = fluidBlock.getFluid().getName();
                return ToxicFluids.findBy(name);
            }
            return null;
        }

        public boolean affectSoilFrom(World world, BlockPos startPos) {
            WorldSearch.Column column = WorldSearch.Column.from((World)world, (BlockPos)startPos);
            boolean affected = false;
            for (BlockPos pos : column.getChain()) {
                int pressure;
                int length;
                SoilChain chain;
                if (pos.func_177956_o() > startPos.func_177956_o() || !(chain = SoilChain.from(world, pos, length = (pressure = column.getTop().func_177956_o() - pos.func_177956_o()) + 2 + 1, column.getTop())).isAffected()) continue;
                affected = true;
            }
            return affected;
        }

        static {
            NAME_LOOKUP = new HashMap<String, ToxicFluids>();
            for (ToxicFluids fluid : ToxicFluids.values()) {
                NAME_LOOKUP.put(fluid.name(), fluid);
            }
        }
    }
}

