/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.entities;

import com.endertech.common.FloatBounds;
import com.endertech.common.IBounds;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.AABB;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.mods.adpother.blocks.Filter;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PollutantFreeAir
extends ForgeEntity {
    protected static final DataParameter<Boolean> FADING = EntityDataManager.func_187226_a(PollutantFreeAir.class, (DataSerializer)DataSerializers.field_187198_h);
    protected final GameTime checkSourceInterval = GameTime.second();
    protected Block pollutant;
    protected BlockPos filterPos;
    protected Block filter;
    protected Percentage concentration;

    public PollutantFreeAir(World world) {
        super(world);
        this.func_70105_a(0.1f, 0.1f);
        this.field_70180_af.func_187214_a(FADING, (Object)false);
    }

    public PollutantFreeAir(World world, BlockPos pos, Pollutant<?> pollutant, BlockPos filterPos) {
        this(world);
        this.pollutant = pollutant;
        this.filterPos = filterPos;
        this.filter = world.func_180495_p(filterPos).func_177230_c();
        this.concentration = Percentage.ZERO;
        Vect3d centeredPos = PollutantFreeAir.getCenteredPosTo((BlockPos)pos);
        this.setAllPositions(centeredPos);
    }

    public static List<PollutantFreeAir> getAllAt(World world, BlockPos pos) {
        AxisAlignedBB aabb = AABB.BLOCK.func_186670_a(pos);
        return world.func_72872_a(PollutantFreeAir.class, aabb);
    }

    public Optional<Pollutant<?>> getPollutant() {
        return this.pollutant instanceof Pollutant ? Optional.of((Pollutant)this.pollutant) : Optional.empty();
    }

    public boolean func_70075_an() {
        return false;
    }

    public void func_70071_h_() {
        if (this.isServerSide()) {
            this.onServerTick();
        } else {
            this.onClientTick();
        }
    }

    protected void onClientTick() {
    }

    protected void onServerTick() {
        if (!this.getPollutant().isPresent() || !this.getFilter().isPresent()) {
            this.func_70106_y();
            return;
        }
        boolean fading = (Boolean)this.field_70180_af.func_187225_a(FADING);
        FloatBounds percentage = ForgeBounds.PERCENTAGE.getFloatBounds();
        int signum = fading ? -1 : 1;
        float speed = 0.2f;
        float value = percentage.enclose(Float.valueOf(this.concentration.getValue() + (float)signum * speed)).floatValue();
        this.concentration = Percentage.value((float)value);
        if (fading && this.concentration.getValue() <= percentage.getMin().floatValue()) {
            this.func_70106_y();
            return;
        }
        if (!this.checkSourceInterval.pastIn(this.field_70170_p)) {
            return;
        }
        boolean renewable = this.hasFilterProperMaterial() && this.isPurifierActive();
        this.field_70180_af.func_187227_b(FADING, (Object)(!renewable ? 1 : 0));
    }

    protected boolean hasFilterProperMaterial() {
        return this.getFilter().flatMap(filter -> Optional.ofNullable(filter.getBlockTile((IBlockAccess)this.field_70170_p, this.filterPos)).map(tile -> tile.getTargetPollutants().contains(this.pollutant))).orElse(false);
    }

    protected boolean isPurifierActive() {
        return this.getPurifier().map(purifier -> purifier.getOutputPos(this.field_70170_p, this.filterPos).equals((Object)this.func_180425_c()) && purifier.isActive(this.field_70170_p, this.filterPos)).orElse(false);
    }

    public Percentage getConcentrationAt(Vec3d position) {
        Filter.AirPurifier purifier = this.getPurifier().orElse(null);
        if (purifier == null) {
            return Percentage.ZERO;
        }
        double distance = this.func_174791_d().func_72438_d(position);
        if (distance <= (double)purifier.effectiveRadius) {
            return this.concentration;
        }
        if (distance > (double)purifier.maximumRadius) {
            return Percentage.ZERO;
        }
        float value = ((Float)FloatBounds.from((Float)Float.valueOf(purifier.effectiveRadius), (Float)Float.valueOf(purifier.maximumRadius)).approxTo((IBounds)FloatBounds.from((Float)Float.valueOf(0.0f), (Float)Float.valueOf(this.concentration.getValue()))).backward((Number)Float.valueOf((float)distance))).floatValue();
        return Percentage.value((float)value);
    }

    public void startFading() {
        this.field_70180_af.func_187227_b(FADING, (Object)true);
    }

    public Optional<Filter.AirPurifier> getPurifier() {
        return this.getFilter().map(filter -> filter.getAirPurifier());
    }

    public Optional<Filter> getFilter() {
        return this.filter instanceof Filter ? Optional.of((Filter)this.filter) : Optional.empty();
    }

    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.pollutant = Block.func_149729_e((int)tag.func_74762_e("pollutantId"));
        this.filter = Block.func_149729_e((int)tag.func_74762_e("filterId"));
        this.filterPos = BlockPos.func_177969_a((long)tag.func_74763_f("filterPos"));
        this.concentration = Percentage.value((float)tag.func_74760_g("concentration"));
        this.field_70180_af.func_187227_b(FADING, (Object)tag.func_74767_n("fading"));
    }

    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("pollutantId", Block.func_149682_b((Block)this.pollutant));
        tag.func_74768_a("filterId", Block.func_149682_b((Block)this.filter));
        tag.func_74772_a("filterPos", this.filterPos.func_177986_g());
        tag.func_74776_a("concentration", this.concentration.getValue());
        tag.func_74757_a("fading", ((Boolean)this.field_70180_af.func_187225_a(FADING)).booleanValue());
    }
}

