/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.config;

import com.endertech.common.CommonString;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.mods.adpother.Main;
import com.endertech.minecraft.mods.adpother.config.IReloadableData;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractParsableList
implements IReloadableData {
    protected final ForgeConfig config;
    protected final String category;
    protected final String key;
    protected final List<String> defaultValues = new ArrayList<String>();
    protected final List<String> configValues = new ArrayList<String>();

    public AbstractParsableList(ForgeConfig config, String category, String key, String[] defaultValues) {
        this.config = config;
        this.category = category;
        this.key = key;
        this.defaultValues.addAll(this.asTrimmedList(true, defaultValues));
    }

    public void addDefaultValues(String ... strings) {
        this.defaultValues.addAll(this.asTrimmedList(true, strings));
    }

    protected abstract String getComment();

    protected abstract void parseConfigValues();

    protected List<String> asTrimmedList(boolean removeEmpty, String ... strings) {
        ArrayList<String> list = new ArrayList<String>();
        for (String str : strings) {
            str = str.trim();
            if (removeEmpty && str.isEmpty()) continue;
            list.add(str);
        }
        return list;
    }

    protected List<String> split(String string, String delimiter) {
        String[] split = string.split(delimiter);
        return this.asTrimmedList(false, split);
    }

    protected List<String> splitArgs(String string) {
        return this.split(string, ",");
    }

    protected void logParsingError(String parsedString) {
        Main.instance.getLogger().error("Unable to parse " + this.key + " from " + CommonString.doubleQuoted((String)parsedString));
    }

    @Override
    public void loadData() {
        String[] strArray = ForgeConfig.getStrArray((ForgeConfig)this.config, (String)this.category, (String)this.key, (String[])this.defaultValues.toArray(new String[0]), (String)this.getComment());
        this.configValues.clear();
        this.configValues.addAll(this.asTrimmedList(true, strArray));
        this.parseConfigValues();
    }
}

