/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.difficulty.buffs;

import CoroUtil.difficulty.UtilEntityBuffs;
import CoroUtil.difficulty.buffs.BuffBase;
import CoroUtil.difficulty.data.cmods.CmodAttributeSpeed;
import CoroUtil.forge.CULog;
import CoroUtil.util.CoroUtilAttributes;
import CoroUtil.util.CoroUtilMisc;
import CoroUtil.util.EnumAttribModifierType;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;

public class BuffSpeed
extends BuffBase {
    public boolean flying;

    public BuffSpeed(boolean flying) {
        this.flying = flying;
    }

    @Override
    public String getTagName() {
        return this.flying ? UtilEntityBuffs.dataEntityBuffed_Speed_Flying : UtilEntityBuffs.dataEntityBuffed_Speed;
    }

    @Override
    public boolean applyBuff(EntityCreature ent, float difficulty) {
        CmodAttributeSpeed cmod = (CmodAttributeSpeed)UtilEntityBuffs.getCmodData(ent, this.getTagName());
        if (cmod != null) {
            double extraMultiplier = (double)difficulty * cmod.difficulty_multiplier;
            if (this.flying) {
                if (ent.func_110148_a(SharedMonsterAttributes.field_193334_e) != null) {
                    double oldValFlying = ent.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111126_e();
                    ent.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(cmod.base_value);
                    ent.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111121_a(new AttributeModifier(CoroUtilAttributes.SPEED_BOOST_UUID, "flying speed multiplier boost", extraMultiplier, EnumAttribModifierType.INCREMENT_MULTIPLY_BASE.ordinal()));
                    if (cmod.max_value != -1.0 && ent.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111126_e() > cmod.max_value) {
                        CoroUtilMisc.removeAllModifiers(ent.func_110148_a(SharedMonsterAttributes.field_193334_e));
                        ent.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(cmod.max_value);
                    }
                    CULog.dbg("mob flying speed went from " + oldValFlying + " to " + ent.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111126_e());
                } else {
                    CULog.dbg("mob flying cmod used on a mob that doesnt have a flying attribute registered");
                }
            } else {
                double oldVal = ent.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
                if (cmod.base_value != -1.0) {
                    ent.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(cmod.base_value);
                }
                ent.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier(CoroUtilAttributes.SPEED_BOOST_UUID, "speed multiplier boost", extraMultiplier, EnumAttribModifierType.INCREMENT_MULTIPLY_BASE.ordinal()));
                if (cmod.max_value != -1.0 && ent.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() > cmod.max_value) {
                    CoroUtilMisc.removeAllModifiers(ent.func_110148_a(SharedMonsterAttributes.field_111263_d));
                    ent.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(cmod.max_value);
                }
                CULog.dbg("mob speed went from " + oldVal + " to " + ent.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            }
        }
        return super.applyBuff(ent, difficulty);
    }
}

