/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.gui.impl;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TextWidget;
import io.github.cdagaming.unicore.impl.TupleConsumer;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.function.BiConsumer;
import net.minecraft.class_388;

public class DynamicEditorGui
extends ExtendedScreen {
    private final TupleConsumer<DynamicEditorGui, String, String> onAdjustEntry;
    private final TupleConsumer<DynamicEditorGui, String, String> onRemoveEntry;
    private final BiConsumer<String, DynamicEditorGui> onAdjustInit;
    private final BiConsumer<String, DynamicEditorGui> onNewInit;
    private final BiConsumer<String, DynamicEditorGui> onHoverPrimaryCallback;
    private final BiConsumer<String, DynamicEditorGui> onHoverSecondaryCallback;
    private final TupleConsumer<String, DynamicEditorGui, Boolean> onSpecificCallback;
    public String attributeName;
    public String primaryMessage;
    public String secondaryMessage;
    public String originalPrimaryMessage;
    public String originalSecondaryMessage;
    public String mainTitle;
    public String primaryText;
    public String secondaryText;
    public boolean initialized = false;
    public boolean isNewValue;
    public boolean isDefaultValue;
    public boolean willRenderSecondaryInput;
    public boolean isModuleMode = false;
    public boolean hasChanged = false;
    public boolean overrideSecondaryRender = false;
    public boolean isPreliminaryData = false;
    public int maxPrimaryLength = -1;
    public int maxSecondaryLength = -1;
    public String resetText;
    public ModuleData defaultData;
    public ModuleData originalData;
    public ModuleData currentData;
    private ExtendedButtonControl proceedButton;
    private ExtendedTextControl primaryInput;
    private ExtendedTextControl secondaryInput;

    public DynamicEditorGui(class_388 parentScreen, String attributeName, BiConsumer<String, DynamicEditorGui> onNewInit, BiConsumer<String, DynamicEditorGui> onAdjustInit, TupleConsumer<DynamicEditorGui, String, String> onAdjustEntry, TupleConsumer<DynamicEditorGui, String, String> onRemoveEntry, TupleConsumer<String, DynamicEditorGui, Boolean> onSpecificCallback, BiConsumer<String, DynamicEditorGui> onHoverPrimaryCallback, BiConsumer<String, DynamicEditorGui> onHoverSecondaryCallback) {
        super(parentScreen);
        this.attributeName = attributeName;
        this.isNewValue = StringUtils.isNullOrEmpty(attributeName);
        this.isDefaultValue = !StringUtils.isNullOrEmpty(attributeName) && "default".equals(attributeName);
        this.onNewInit = onNewInit;
        this.onAdjustInit = onAdjustInit;
        this.onAdjustEntry = onAdjustEntry;
        this.onRemoveEntry = onRemoveEntry;
        this.onSpecificCallback = onSpecificCallback;
        this.onHoverPrimaryCallback = onHoverPrimaryCallback;
        this.onHoverSecondaryCallback = onHoverSecondaryCallback;
    }

    public DynamicEditorGui(class_388 parentScreen, String attributeName, BiConsumer<String, DynamicEditorGui> onNewInit, BiConsumer<String, DynamicEditorGui> onAdjustInit, TupleConsumer<DynamicEditorGui, String, String> onAdjustEntry, TupleConsumer<DynamicEditorGui, String, String> onRemoveEntry, TupleConsumer<String, DynamicEditorGui, Boolean> onSpecificCallback, BiConsumer<String, DynamicEditorGui> onHoverPrimaryCallback) {
        this(parentScreen, attributeName, onNewInit, onAdjustInit, onAdjustEntry, onRemoveEntry, onSpecificCallback, onHoverPrimaryCallback, (name, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.value.name", new Object[0]))));
    }

    public DynamicEditorGui(class_388 parentScreen, String attributeName, BiConsumer<String, DynamicEditorGui> onNewInit, BiConsumer<String, DynamicEditorGui> onAdjustInit, TupleConsumer<DynamicEditorGui, String, String> onAdjustEntry, TupleConsumer<DynamicEditorGui, String, String> onRemoveEntry, TupleConsumer<String, DynamicEditorGui, Boolean> onSpecificCallback) {
        this(parentScreen, attributeName, onNewInit, onAdjustInit, onAdjustEntry, onRemoveEntry, onSpecificCallback, (name, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.value.message", new Object[0]))));
    }

    @Override
    public void initializeUi() {
        int controlIndex = 1;
        if (!this.isLoaded() && !this.initialized) {
            this.resetText = "gui.config.message.button.remove";
            if (this.isNewValue) {
                this.mainTitle = Constants.TRANSLATOR.translate("gui.config.title.editor.add.new", new Object[0]);
                if (this.onNewInit != null) {
                    this.onNewInit.accept(this.attributeName, this);
                }
            } else if (this.onAdjustInit != null) {
                this.onAdjustInit.accept(this.attributeName, this);
            }
            this.initialized = true;
        }
        this.isModuleMode = this.defaultData != null || this.currentData != null;
        boolean bl = this.willRenderSecondaryInput = this.isNewValue || this.overrideSecondaryRender;
        if (StringUtils.isNullOrEmpty(this.primaryText)) {
            this.primaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.message", new Object[0]);
        }
        if (StringUtils.isNullOrEmpty(this.secondaryText)) {
            this.secondaryText = Constants.TRANSLATOR.translate("gui.config.message.editor.value.name", new Object[0]);
        }
        if (this.isNewValue || this.isPreliminaryData) {
            if (this.isPreliminaryData && !StringUtils.isNullOrEmpty(this.attributeName)) {
                this.mainTitle = Constants.TRANSLATOR.translate("gui.config.title.editor.add.new.prefilled", this.attributeName);
            }
            if (this.isModuleMode && this.defaultData != null && this.currentData == null) {
                this.currentData = new ModuleData(this.defaultData);
            }
        } else if (!this.isDefaultValue) {
            this.addControl(new ExtendedButtonControl(6, this.getScreenHeight() - 26, 95, 20, this.resetText, () -> {
                if (this.onRemoveEntry != null) {
                    this.onRemoveEntry.accept(this, this.willRenderSecondaryInput ? this.secondaryInput.getControlMessage() : this.attributeName, this.primaryInput.getControlMessage());
                }
                this.openScreen(this.parentScreen);
            }, new String[0]));
        }
        if (this.isModuleMode && this.originalData == null) {
            this.originalData = new ModuleData(this.currentData);
        }
        this.primaryInput = this.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(controlIndex++), 180, 20, this.primaryText, () -> {
            if (this.onHoverPrimaryCallback != null) {
                this.onHoverPrimaryCallback.accept(this.attributeName, this);
            }
        }));
        if (this.maxPrimaryLength > 0) {
            this.primaryInput.setControlMaxLength(this.maxPrimaryLength);
        }
        if (!StringUtils.isNullOrEmpty(this.primaryMessage)) {
            this.primaryInput.setControlMessage(this.primaryMessage);
        }
        if (this.onSpecificCallback != null) {
            this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getButtonY(controlIndex++), 180, 20, "gui.config.message.button.icon.change", () -> this.onSpecificCallback.accept(this.attributeName, this, false), new String[0]));
            this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getButtonY(controlIndex++), 180, 20, "gui.config.title.presence_settings", () -> this.onSpecificCallback.accept(this.attributeName, this, true), new String[0]));
        }
        if (this.willRenderSecondaryInput) {
            this.secondaryInput = this.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(controlIndex), 180, 20, this.secondaryText, () -> {
                if (this.onHoverSecondaryCallback != null) {
                    this.onHoverSecondaryCallback.accept(this.attributeName, this);
                }
            }));
            if (this.maxSecondaryLength > 0) {
                this.secondaryInput.setControlMaxLength(this.maxSecondaryLength);
            }
            if (!StringUtils.isNullOrEmpty(this.secondaryMessage)) {
                this.secondaryInput.setControlMessage(this.secondaryMessage);
            }
        }
        this.proceedButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getScreenHeight() - 26, 180, 20, "gui.config.message.button.back", () -> {
            if (StringUtils.isNullOrEmpty(this.attributeName) && this.willRenderSecondaryInput && !StringUtils.isNullOrEmpty(this.secondaryInput.getControlMessage())) {
                this.attributeName = this.secondaryInput.getControlMessage();
            }
            if (this.isAdjusting() && this.onAdjustEntry != null) {
                this.onAdjustEntry.accept(this, this.willRenderSecondaryInput ? this.secondaryInput.getControlMessage() : this.attributeName, this.primaryInput.getControlMessage());
            }
            this.openScreen(this.parentScreen);
        }, () -> {
            if (!this.proceedButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(Constants.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])));
            }
        }, new String[0]));
        super.initializeUi();
    }

    @Override
    public void preRender() {
        this.proceedButton.setControlMessage(this.isAdjusting() ? "gui.config.message.button.continue" : "gui.config.message.button.back");
        this.proceedButton.setControlEnabled(this.isValidEntries());
        super.preRender();
    }

    @Override
    public void renderExtra() {
        this.renderScrollingString(this.mainTitle, 30, 0, this.getScreenWidth() - 30, 32, 0xFFFFFF);
        super.renderExtra();
    }

    private boolean isAdjusting() {
        String primaryText = this.primaryInput != null ? this.primaryInput.getControlMessage() : "";
        boolean isPrimaryEmpty = StringUtils.isNullOrEmpty(primaryText);
        String secondaryText = this.secondaryInput != null ? this.secondaryInput.getControlMessage() : "";
        boolean isSecondaryEmpty = StringUtils.isNullOrEmpty(secondaryText);
        if (this.isModuleMode) {
            boolean bl = this.hasChanged = this.currentData.getData() != null && !this.currentData.getData().equals(this.originalData.getData());
            if (!this.hasChanged) {
                String originalIcon = this.originalData.getIconOverride() != null ? this.originalData.getIconOverride() : "";
                String currentIcon = this.currentData.getIconOverride() != null ? this.currentData.getIconOverride() : "";
                boolean bl2 = this.hasChanged = this.hasChanged || !currentIcon.equals(originalIcon);
            }
        }
        if (this.hasChanged) {
            return true;
        }
        if (this.willRenderSecondaryInput) {
            return !isSecondaryEmpty && (!primaryText.equals(this.primaryMessage) || !secondaryText.equals(this.secondaryMessage));
        }
        if (this.isDefaultValue) {
            return !isPrimaryEmpty && !primaryText.equals(this.primaryMessage);
        }
        return !primaryText.equals(this.primaryMessage);
    }

    private boolean isValidEntries() {
        String primaryText = this.primaryInput != null ? this.primaryInput.getControlMessage() : "";
        boolean isPrimaryEmpty = StringUtils.isNullOrEmpty(primaryText);
        if (this.isDefaultValue) {
            return !isPrimaryEmpty;
        }
        return true;
    }
}

