/*
 * Decompiled with CFR 0.152.
 */
package external.net.lenni0451.reflect.stream.constructor;

import external.net.lenni0451.reflect.Constructors;
import external.net.lenni0451.reflect.exceptions.ConstructorNotFoundException;
import external.net.lenni0451.reflect.stream.RStream;
import external.net.lenni0451.reflect.stream.constructor.ConstructorWrapper;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ConstructorStream {
    private final RStream parent;
    private final List<ConstructorWrapper> constructors;

    public ConstructorStream(RStream parent) {
        this.parent = parent;
        this.constructors = new ArrayList<ConstructorWrapper>();
        for (Constructor<?> constructor : Constructors.getDeclaredConstructors(parent.clazz())) {
            this.constructors.add(new ConstructorWrapper(this, constructor));
        }
    }

    public RStream parent() {
        return this.parent;
    }

    public int size() {
        return this.constructors.size();
    }

    public Optional<ConstructorWrapper> opt(Class<?> ... parameterTypes) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            for (ConstructorWrapper constructor : this.constructors) {
                if (constructor.parameterTypes().length != 0) continue;
                return Optional.of(constructor);
            }
        } else {
            for (ConstructorWrapper constructor : this.constructors) {
                if (!Arrays.equals(constructor.parameterTypes(), parameterTypes)) continue;
                return Optional.of(constructor);
            }
        }
        return Optional.empty();
    }

    public Optional<ConstructorWrapper> opt(int index) {
        if (index < 0 || index > this.constructors.size()) {
            return Optional.empty();
        }
        return Optional.of(this.constructors.get(index));
    }

    public ConstructorWrapper by(Class<?> ... parameterTypes) {
        return this.opt(parameterTypes).orElseThrow(() -> new ConstructorNotFoundException(this.parent.clazz().getName(), parameterTypes));
    }

    public ConstructorWrapper by(int index) {
        return this.opt(index).orElseThrow(() -> new ConstructorNotFoundException(this.parent.clazz().getName(), String.valueOf(index)));
    }

    public ConstructorStream filter(Predicate<ConstructorWrapper> filter) {
        this.constructors.removeIf(filter.negate());
        return this;
    }

    public ConstructorStream filter(Class<?> ... parameterTypes) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            return this.filter((ConstructorWrapper constructor) -> constructor.parameterCount() == 0);
        }
        return this.filter((ConstructorWrapper constructor) -> Arrays.equals(constructor.parameterTypes(), parameterTypes));
    }

    public ConstructorStream filter(boolean isStatic) {
        return this.filter((ConstructorWrapper constructor) -> constructor.modifier().isStatic() == isStatic);
    }

    public Iterator<ConstructorWrapper> iterator() {
        return this.constructors.iterator();
    }

    public Stream<ConstructorWrapper> jstream() {
        return this.constructors.stream();
    }

    public ConstructorStream forEach(Consumer<ConstructorWrapper> consumer) {
        this.constructors.forEach(consumer);
        return this;
    }
}

