/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import de.maxhenkel.voicechat.gui.widgets.ButtonBase;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class KeybindButton
extends ButtonBase {
    private static final Minecraft mc = Minecraft.func_71410_x();
    protected KeyBinding keyMapping;
    @Nullable
    protected ITextComponent description;
    protected boolean listening;

    public KeybindButton(int id, KeyBinding mapping, int x, int y, int width, int height, @Nullable ITextComponent description) {
        super(id, x, y, width, height, "");
        this.keyMapping = mapping;
        this.description = description;
        this.updateText();
    }

    public KeybindButton(int id, KeyBinding mapping, int x, int y, int width, int height) {
        this(id, mapping, x, y, width, height, null);
    }

    protected void updateText() {
        ITextComponent text = this.listening ? new TextComponentString("> ").func_150257_a(KeybindButton.getText(this.keyMapping).func_150255_a(new Style().func_150238_a(TextFormatting.BOLD).func_150238_a(TextFormatting.UNDERLINE))).func_150258_a(" <").func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)) : KeybindButton.getText(this.keyMapping);
        if (this.description != null) {
            text = new TextComponentString("").func_150257_a(this.description).func_150258_a(": ").func_150257_a(text);
        }
        this.field_146126_j = text.func_150254_d();
    }

    private static ITextComponent getText(KeyBinding keyMapping) {
        return new TextComponentString(keyMapping.getDisplayName());
    }

    public boolean isHovered() {
        return this.field_146123_n;
    }

    @Override
    public void onPress() {
        this.listening = true;
        this.updateText();
    }

    public boolean mousePressed(int button) {
        if (this.listening) {
            this.setKeyBind(button - 100);
            this.listening = false;
            this.updateText();
            return true;
        }
        return false;
    }

    public boolean keyPressed(int key) {
        if (this.listening) {
            if (key == 1) {
                this.setKeyBind(0);
            } else {
                this.setKeyBind(key);
            }
            this.listening = false;
            this.updateText();
            return true;
        }
        return false;
    }

    protected void setKeyBind(int key) {
        KeybindButton.mc.field_71474_y.func_151440_a(this.keyMapping, key);
        KeyBinding.func_74508_b();
    }

    public boolean isListening() {
        return this.listening;
    }
}

