/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.client.model.paint.loaders.customs;

import com.silvaniastudios.roads.blocks.diagonal.ShapeLibrary;
import com.silvaniastudios.roads.blocks.enums.EnumTwoLengthConnectable;
import com.silvaniastudios.roads.blocks.paint.PaintBlockBase;
import com.silvaniastudios.roads.blocks.paint.customs.Custom1x2PaintBlock;
import com.silvaniastudios.roads.blocks.paint.customs.ICustomBlock;
import com.silvaniastudios.roads.client.model.paint.PaintBakedModelBase;
import com.silvaniastudios.roads.client.render.Quad;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;

class CustomPaint2x1BakedModel
extends PaintBakedModelBase {
    public CustomPaint2x1BakedModel(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        super(state, format, bakedTextureGetter);
        this.populateSprites();
    }

    @Override
    protected List<BakedQuad> packQuads(IBlockState state) {
        int gridId;
        int yRot;
        int xRot;
        TextureAtlasSprite tex;
        if (state != null) {
            int colId = ((PaintBlockBase)state.func_177230_c()).getColour().getId();
            tex = this.sprites[colId];
            EnumTwoLengthConnectable rotState = (EnumTwoLengthConnectable)((Object)state.func_177229_b(Custom1x2PaintBlock.CONNECT));
            xRot = 0;
            yRot = 45;
            gridId = 0;
            switch (rotState) {
                case n1: {
                    yRot = 0;
                    break;
                }
                case e1: {
                    yRot = 270;
                    break;
                }
                case s1: {
                    yRot = 180;
                    break;
                }
                case w1: {
                    yRot = 90;
                    break;
                }
                case n2: {
                    yRot = 0;
                    gridId = 1;
                    break;
                }
                case e2: {
                    yRot = 270;
                    gridId = 1;
                    break;
                }
                case s2: {
                    yRot = 180;
                    gridId = 1;
                    break;
                }
                case w2: {
                    yRot = 90;
                    gridId = 1;
                }
            }
        } else {
            return this.handleItemRendering();
        }
        boolean[][] grid = ((ICustomBlock)state.func_177230_c()).getGrid(gridId).getGrid();
        List<Quad> rawQuads = ShapeLibrary.shapeFromGrid(grid, 0.015625f, tex, this.format, false);
        List<BakedQuad> quads = this.shapeBuilder(rawQuads, new ArrayList<BakedQuad>(), xRot, yRot);
        return quads;
    }
}

