/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.client.model.paint.loaders.customs;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.blocks.diagonal.ShapeLibrary;
import com.silvaniastudios.roads.blocks.enums.EnumMeta;
import com.silvaniastudios.roads.blocks.paint.customs.CustomMetaPaintBlock;
import com.silvaniastudios.roads.blocks.paint.properties.PaintGrid;
import com.silvaniastudios.roads.client.model.paint.PaintBakedModelBase;
import com.silvaniastudios.roads.client.render.Quad;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;

class CustomMetaPaintBakedModel
extends PaintBakedModelBase {
    public CustomMetaPaintBakedModel(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        super(state, format, bakedTextureGetter);
        this.populateSprites();
    }

    @Override
    protected List<BakedQuad> packQuads(IBlockState state) {
        TextureAtlasSprite tex;
        EnumMeta meta;
        CustomMetaPaintBlock block;
        if (state != null) {
            block = (CustomMetaPaintBlock)state.func_177230_c();
            int colId = block.getColour().getId();
            meta = (EnumMeta)((Object)state.func_177229_b(CustomMetaPaintBlock.META_ID));
            tex = this.sprites[colId];
            if (this.getGrid(meta.getMetadata(), block) == null) {
                FurenikusRoads.debug(0, "Failed to load paint grid for " + block.getLocalName() + " and meta " + meta.getMetadata());
                List<Quad> rawQuads = ShapeLibrary.shapeFromGrid(PaintGrid.EMPTY.getGrid(), 0.015625f, tex, this.format, false);
                List<BakedQuad> quads = this.shapeBuilder(rawQuads, new ArrayList<BakedQuad>(), 0, 0);
                return quads;
            }
        } else {
            return this.handleItemRendering();
        }
        boolean[][] grid = this.getGrid(meta.getMetadata(), block).getGrid();
        int xRot = 0;
        int yRot = meta.getRotation();
        List<Quad> rawQuads = ShapeLibrary.shapeFromGrid(grid, 0.015625f, tex, this.format, false);
        List<BakedQuad> quads = this.shapeBuilder(rawQuads, new ArrayList<BakedQuad>(), xRot, yRot);
        return quads;
    }

    private PaintGrid getGrid(int meta, CustomMetaPaintBlock block) {
        int gridId = 0;
        int[] metas = new int[]{0, 4, 8, 12};
        for (int i = 0; i < metas.length; ++i) {
            if (meta < metas[i]) continue;
            gridId = i;
        }
        return block.getGrid(gridId);
    }

    protected List<BakedQuad> shapeBuilderItem(List<Quad> rawQuads, List<BakedQuad> quads, int col, int yRot) {
        for (int i = 0; i < rawQuads.size(); ++i) {
            if (rawQuads.get(i) == null) continue;
            Quad.rotateQuadX(rawQuads.get(i), 90);
            rawQuads.set(i, Quad.rotateQuadY(rawQuads.get(i), yRot));
            BakedQuad baked = rawQuads.get(i).createQuad(col);
            quads.add(baked);
        }
        return quads;
    }
}

