/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.client.model.paint;

import com.silvaniastudios.roads.blocks.FRBlocks;
import com.silvaniastudios.roads.blocks.diagonal.ShapeLibrary;
import com.silvaniastudios.roads.blocks.paint.PaintBlockBase;
import com.silvaniastudios.roads.blocks.paint.customs.CustomPaintBlock;
import com.silvaniastudios.roads.client.render.Quad;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.Loader;

public abstract class PaintBakedModelBase
implements IBakedModel {
    private final String foamFixModId = "foamfix";
    private final PaintOverrideList overrideList;
    protected TextureAtlasSprite[] sprites;
    protected ItemStack stack;
    protected VertexFormat format;
    protected Minecraft mc;
    private List<BakedQuad> itemQuadsCache = null;

    public PaintBakedModelBase(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        this.format = format;
        this.mc = Minecraft.func_71410_x();
        this.stack = null;
        this.overrideList = new PaintOverrideList(this);
    }

    protected void populateSprites() {
        this.sprites = new TextureAtlasSprite[FRBlocks.col.size()];
        for (int i = 0; i < FRBlocks.col.size(); ++i) {
            this.sprites[i] = this.mc.func_147117_R().func_110572_b("furenikusroads:blocks/paint_" + FRBlocks.col.get(i).getName());
        }
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (side != null) {
            return Collections.emptyList();
        }
        return this.packQuads(state);
    }

    protected List<BakedQuad> packQuads(IBlockState state) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        return quads;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrideList;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return Minecraft.func_71410_x().func_147117_R().func_110572_b("furenikusroads:blocks/road_block_standard");
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public List<BakedQuad> handleItemRendering() {
        List<BakedQuad> quads = new ArrayList<BakedQuad>();
        List<Quad> rawQuads = new ArrayList<Quad>();
        CustomPaintBlock paintBlock = (CustomPaintBlock)((ItemBlock)this.stack.func_77973_b()).func_179223_d();
        if (paintBlock.isInternal()) {
            List<Quad> spriteQuads = this.getSpriteQuads();
            rawQuads.addAll(spriteQuads);
            quads = this.shapeBuilderItem(rawQuads, quads, paintBlock.getColour().getColourInt(), 0, 0);
            return quads;
        }
        if (this.itemQuadsCache == null) {
            int colId = paintBlock.getColour().getId();
            boolean[][] grid = paintBlock.getGrid(this.stack.func_77952_i() < 7 ? 0 : 1).getGrid();
            rawQuads = ShapeLibrary.shapeFromGrid(grid, 0.5f, this.sprites[colId], this.format, !Loader.isModLoaded((String)"foamfix"));
            this.itemQuadsCache = this.shapeBuilderItem(rawQuads, quads, paintBlock.getColour().getColourInt(), 90, this.stack.func_82839_y() ? 180 : 0);
        }
        return this.itemQuadsCache;
    }

    protected List<BakedQuad> shapeBuilderItem(List<Quad> rawQuads, List<BakedQuad> quads, int col, int xRot, int yRot) {
        for (int i = 0; i < rawQuads.size(); ++i) {
            if (rawQuads.get(i) == null) continue;
            Quad.rotateQuadX(rawQuads.get(i), xRot);
            rawQuads.set(i, Quad.rotateQuadY(rawQuads.get(i), yRot));
            BakedQuad baked = rawQuads.get(i).createQuad(col);
            quads.add(baked);
        }
        return quads;
    }

    public List<Quad> getSpriteQuads() {
        PaintBlockBase paintBlock = (PaintBlockBase)((ItemBlock)this.stack.func_77973_b()).func_179223_d();
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b("furenikusroads:paints/" + paintBlock.getIconName() + "_" + this.stack.func_77952_i());
        return this.getSpriteQuads(sprite);
    }

    public List<Quad> getSpriteQuads(TextureAtlasSprite sprite) {
        ArrayList<Quad> quads = new ArrayList<Quad>();
        Quad front = new Quad(new Vec3d(0.0, 1.0, 0.5), 16.0f, 0.0f, new Vec3d(1.0, 1.0, 0.5), 0.0f, 0.0f, new Vec3d(1.0, 0.0, 0.5), 0.0f, 16.0f, new Vec3d(0.0, 0.0, 0.5), 16.0f, 16.0f, sprite, this.format);
        Quad back = new Quad(new Vec3d(1.0, 1.0, 0.5), 16.0f, 0.0f, new Vec3d(0.0, 1.0, 0.5), 0.0f, 0.0f, new Vec3d(0.0, 0.0, 0.5), 0.0f, 16.0f, new Vec3d(1.0, 0.0, 0.5), 16.0f, 16.0f, sprite, this.format);
        if (!Loader.isModLoaded((String)"foamfix")) {
            quads.add(front);
        }
        quads.add(back);
        return quads;
    }

    public PaintBakedModelBase setCurrentItemStack(ItemStack stack) {
        this.stack = stack;
        return this;
    }

    protected List<BakedQuad> shapeBuilder(List<Quad> rawQuads, List<BakedQuad> quads, int rotX, int rotY) {
        int i;
        for (i = 0; i < rawQuads.size(); ++i) {
            if (rawQuads.get(i) == null) continue;
            Quad.rotateQuadX(rawQuads.get(i), rotX);
            rawQuads.set(i, Quad.rotateQuadY(rawQuads.get(i), rotY));
        }
        if (!rawQuads.isEmpty()) {
            if (rawQuads.get(0) != null) {
                rawQuads.get(0).updateUVs();
            }
            if (rawQuads.get(1) != null) {
                rawQuads.get(1).setFlipV(true);
                rawQuads.get(1).updateUVs();
            }
        }
        for (i = 0; i < rawQuads.size(); ++i) {
            if (rawQuads.get(i) == null) continue;
            BakedQuad baked = rawQuads.get(i).createQuad(0);
            quads.add(baked);
        }
        return quads;
    }

    private static class PaintOverrideList
    extends ItemOverrideList {
        private PaintBakedModelBase model;

        public PaintOverrideList(PaintBakedModelBase model) {
            super(Collections.emptyList());
            this.model = model;
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            return this.model.setCurrentItemStack(stack);
        }
    }
}

