/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.client.gui.paintgun;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.blocks.paint.PaintBlockBase;
import com.silvaniastudios.roads.client.gui.paintgun.PaintGunCategoryList;
import com.silvaniastudios.roads.client.gui.paintgun.PaintGunPaintList;
import com.silvaniastudios.roads.items.PaintGun;
import com.silvaniastudios.roads.network.PaintGunUpdatePacket;
import com.silvaniastudios.roads.registries.PaintCategoryList;
import com.silvaniastudios.roads.registries.PaintGunItemRegistry;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiPaintGun
extends GuiScreen {
    private final int guiWidth = 256;
    private final int guiHeight = 200;
    PaintGunCategoryList categoryList;
    ArrayList<PaintGunPaintList> paintLists = new ArrayList();
    ArrayList<String> tooltipList = new ArrayList();
    private GuiButton whitePaint;
    private GuiButton yellowPaint;
    private GuiButton redPaint;
    private GuiButton sizeSmall;
    private GuiButton sizeLarge;
    private int currentPageId = 0;
    private int selectedPageId = 0;
    private int selectedSlotId = 0;
    private String selectedColour = "white";
    private boolean isLarge = false;
    private int gun_white = 0;
    private int gun_yellow = 0;
    private int gun_red = 0;
    private static ResourceLocation texture = new ResourceLocation("furenikusroads:textures/gui/paint_gun_background.png");
    private static ResourceLocation texture_2 = new ResourceLocation("furenikusroads:textures/gui/paint_gun_background_2.png");

    public int getCategoryId() {
        return this.currentPageId;
    }

    public int getSelectedCategoryId() {
        return this.selectedPageId;
    }

    public int getSlotId() {
        return this.selectedSlotId;
    }

    public void setPageId(int id) {
        this.currentPageId = id;
    }

    public void setSelectedId(int id) {
        this.selectedPageId = this.currentPageId;
        this.selectedSlotId = id;
        FurenikusRoads.PACKET_CHANNEL.sendToServer((IMessage)new PaintGunUpdatePacket(this.selectedSlotId, this.selectedColour, this.currentPageId, this.isLarge));
    }

    public void setCategoryId(int id) {
        this.paintLists.get(this.currentPageId).setEnabled(false);
        this.currentPageId = id;
        this.paintLists.get(this.currentPageId).setEnabled(true);
    }

    public void func_73866_w_() {
        ItemStack item = this.field_146297_k.field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
        if (item.func_77973_b() instanceof PaintGun && item.func_77942_o()) {
            NBTTagCompound nbt = item.func_77978_p();
            this.selectedColour = nbt.func_74779_i("colour");
            this.selectedPageId = this.currentPageId = nbt.func_74762_e("pageId");
            this.isLarge = nbt.func_74767_n("isLarge");
            this.selectedSlotId = nbt.func_74762_e("selectedId");
            this.gun_white = nbt.func_74762_e("white_paint");
            this.gun_yellow = nbt.func_74762_e("yellow_paint");
            this.gun_red = nbt.func_74762_e("red_paint");
        }
        int guiLeft = (this.field_146294_l - 256) / 2;
        int guiTop = (this.field_146295_m - 200) / 2;
        this.categoryList = new PaintGunCategoryList(100, 182, guiTop + 10, guiLeft + 8, 20, this.field_146294_l, this.field_146295_m, this.field_146289_q, this.field_146297_k, this);
        for (int i = 0; i < PaintGunItemRegistry.categoryList.size(); ++i) {
            PaintCategoryList category = PaintGunItemRegistry.categoryList.get(i);
            PaintGunPaintList list = new PaintGunPaintList(132, 154, guiTop + 10, guiLeft + 114, 25, this.field_146294_l, this.field_146295_m, this.field_146289_q, this.field_146297_k, this, category.getWhitePaints(), this.tooltipList);
            if (i == this.currentPageId) {
                list.setEnabled(true);
            }
            this.paintLists.add(list);
        }
        this.whitePaint = new GuiButton(47, guiLeft + 113, guiTop + 171, 42, 20, "White");
        this.yellowPaint = new GuiButton(48, guiLeft + 158, guiTop + 171, 43, 20, TextFormatting.YELLOW + "Yellow");
        this.redPaint = new GuiButton(49, guiLeft + 204, guiTop + 171, 42, 20, TextFormatting.RED + "Red");
        this.sizeSmall = new GuiButton(50, guiLeft + 118, guiTop + 140, 60, 20, "Small");
        this.sizeLarge = new GuiButton(51, guiLeft + 182, guiTop + 140, 60, 20, "Large");
        this.field_146292_n.add(this.whitePaint);
        this.field_146292_n.add(this.yellowPaint);
        this.field_146292_n.add(this.redPaint);
        this.field_146292_n.add(this.sizeSmall);
        this.field_146292_n.add(this.sizeLarge);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73876_c() {
        if (this.selectedColour.equals("white")) {
            this.whitePaint.field_146124_l = false;
            this.yellowPaint.field_146124_l = true;
            this.redPaint.field_146124_l = true;
        }
        if (this.selectedColour.equals("yellow")) {
            this.whitePaint.field_146124_l = true;
            this.yellowPaint.field_146124_l = false;
            this.redPaint.field_146124_l = true;
        }
        if (this.selectedColour.equals("red")) {
            this.whitePaint.field_146124_l = true;
            this.yellowPaint.field_146124_l = true;
            this.redPaint.field_146124_l = false;
        }
        this.sizeSmall.field_146125_m = false;
        this.sizeLarge.field_146125_m = false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        try {
            this.paintLists.get(this.currentPageId).handleMouseInput(mouseX, mouseY);
            this.categoryList.handleMouseInput(mouseX, mouseY);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int guiLeft = (this.field_146294_l - 256) / 2;
        int guiTop = (this.field_146295_m - 200) / 2;
        this.func_73729_b(guiLeft, guiTop, 0, 0, 256, 200);
        this.field_146297_k.func_110434_K().func_110577_a(texture_2);
        this.func_73729_b(guiLeft + 256, guiTop, 0, 0, 50, 70);
        this.drawGunFillBar(0, guiLeft, guiTop, this.gun_white);
        this.drawGunFillBar(1, guiLeft, guiTop, this.gun_yellow);
        this.drawGunFillBar(2, guiLeft, guiTop, this.gun_red);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.categoryList.drawScreen(mouseX, mouseY, partialTicks);
        for (int i = 0; i < this.paintLists.size(); ++i) {
            if (!this.paintLists.get(i).isEnabled()) continue;
            this.tooltipList.clear();
            this.paintLists.get(i).drawScreen(mouseX, mouseY, partialTicks);
            if (this.tooltipList.size() <= 0) continue;
            this.func_146283_a(this.tooltipList, mouseX, mouseY);
        }
        this.drawTooltip(guiLeft + 256, guiTop, mouseX, mouseY);
    }

    public String getSelectedColour() {
        return this.selectedColour;
    }

    private void drawTooltip(int left, int top, int mouseX, int mouseY) {
        if (mouseX >= left && mouseX <= left + 10 && mouseY >= top + 10 && mouseY <= top + 60) {
            this.func_146279_a(this.gun_white + "/" + 32000, mouseX, mouseY);
        }
        if (mouseX >= left + 16 && mouseX <= left + 26 && mouseY >= top + 10 && mouseY <= top + 60) {
            this.func_146279_a(this.gun_yellow + "/" + 32000, mouseX, mouseY);
        }
        if (mouseX >= left + 32 && mouseX <= left + 42 && mouseY >= top + 10 && mouseY <= top + 60) {
            this.func_146279_a(this.gun_red + "/" + 32000, mouseX, mouseY);
        }
    }

    private void drawGunFillBar(int col, int left, int top, int fill) {
        int p = Math.round((float)this.getPercentage(fill, 32000) / 2.0f);
        this.func_73729_b(left + 256 + col * 16, top + 60 - p, 50 + col * 10, 0 + (50 - p), 10, p);
    }

    private int getPercentage(int num, int max) {
        float x = (float)num / (float)max;
        int y = Math.round(x * 100.0f);
        if (y > 100) {
            return 100;
        }
        return y;
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.whitePaint) {
            this.selectedColour = "white";
        }
        if (button == this.yellowPaint) {
            this.selectedColour = "yellow";
        }
        if (button == this.redPaint) {
            this.selectedColour = "red";
        }
        if (button == this.sizeSmall) {
            this.isLarge = false;
        }
        if (button == this.sizeLarge) {
            this.isLarge = true;
        }
        FurenikusRoads.PACKET_CHANNEL.sendToServer((IMessage)new PaintGunUpdatePacket(this.selectedSlotId, this.selectedColour, this.selectedPageId, this.isLarge));
    }

    public PaintBlockBase getSelectionFromId(int sel) {
        if (PaintGunItemRegistry.categoryList.size() >= this.selectedPageId) {
            PaintCategoryList cat = PaintGunItemRegistry.categoryList.get(this.selectedPageId);
            if (cat.size() >= sel) {
                return cat.getPaint(sel);
            }
            return cat.getPaint(0);
        }
        return PaintGunItemRegistry.categoryList.get(0).getPaint(0);
    }
}

