/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.client.gui;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.tileentities.compactor.CompactorContainer;
import com.silvaniastudios.roads.blocks.tileentities.compactor.CompactorElectricEntity;
import com.silvaniastudios.roads.blocks.tileentities.compactor.CompactorEntity;
import com.silvaniastudios.roads.network.CompactorUpdatePacket;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiCompactor
extends GuiContainer {
    private static final ResourceLocation guiTextures = new ResourceLocation("furenikusroads:textures/gui/compactor.png");
    private CompactorEntity tileEntity;
    private boolean electric;
    GuiButton increase;
    GuiButton decrease;

    public GuiCompactor(CompactorEntity tileEntity, CompactorContainer container, boolean electric) {
        super((Container)container);
        this.field_146999_f = 176;
        this.field_147000_g = 146;
        this.tileEntity = tileEntity;
        this.electric = electric;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int guiLeft = (this.field_146294_l - this.field_146999_f) / 2;
        int guiTop = (this.field_146295_m - this.field_147000_g) / 2;
        this.increase = new GuiButton(0, guiLeft + 91, guiTop + 30, 20, 20, "+");
        this.decrease = new GuiButton(1, guiLeft + 43, guiTop + 30, 20, 20, "-");
        this.field_146292_n.add(this.increase);
        this.field_146292_n.add(this.decrease);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int left = (this.field_146294_l - this.field_146999_f) / 2;
        int top = (this.field_146295_m - this.field_147000_g) / 2;
        this.drawTooltip(2, left, top, mouseX, mouseY);
        if (this.electric) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"roads.gui.compactor_electric.name", (Object[])new Object[0]), 6, 6, 0x404040);
        } else {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"roads.gui.compactor.name", (Object[])new Object[0]), 6, 6, 0x404040);
        }
        String str = "" + (this.tileEntity.road_size + 1);
        this.field_146289_q.func_78276_b(str, 77 - this.field_146289_q.func_78256_a(str) / 2, 36, 0x404040);
    }

    private void drawTooltip(int col, int left, int top, int mouseX, int mouseY) {
        if (this.electric) {
            CompactorElectricEntity cee = (CompactorElectricEntity)this.tileEntity;
            if (mouseX >= left + 155 && mouseX <= left + 169 && mouseY >= top + 7 && mouseY <= top + 49) {
                this.func_146279_a(cee.energy.getEnergyStored() + "/" + cee.energy.getMaxEnergyStored(), mouseX - left, mouseY - top + 15);
            }
        } else if (mouseX >= left + 153 && mouseX <= left + 167 && mouseY >= top + 15 && mouseY <= top + 29) {
            this.func_146279_a(this.tileEntity.fuel_remaining + "/" + this.tileEntity.last_fuel_cap, mouseX - left, mouseY - top + 15);
        }
        if (RoadsConfig.general.guiGuide) {
            if (mouseX >= left + 8 && mouseX <= left + 24 && mouseY >= top + 32 && mouseY <= top + 48 && this.tileEntity.inventory.getStackInSlot(0).func_190916_E() == 0) {
                this.func_146279_a(I18n.func_135052_a((String)"roads.gui.compactor.fragmentSlot", (Object[])new Object[0]), mouseX - left, mouseY - top + 15);
            }
            if (mouseX >= left + 130 && mouseX <= left + 146 && mouseY >= top + 32 && mouseY <= top + 48 && this.tileEntity.inventory.getStackInSlot(1).func_190916_E() == 0) {
                this.func_146279_a(I18n.func_135052_a((String)"roads.gui.outputSlot", (Object[])new Object[0]), mouseX - left, mouseY - top + 15);
            }
            if (mouseX >= left + 152 && mouseX <= left + 168 && mouseY >= top + 32 && mouseY <= top + 48 && this.tileEntity.inventory.getStackInSlot(2).func_190916_E() == 0 && !this.electric) {
                this.func_146279_a(I18n.func_135052_a((String)"roads.gui.fuelSlot", (Object[])new Object[0]), mouseX - left, mouseY - top + 15);
            }
            if (mouseX >= left + 63 && mouseX <= left + 90 && mouseY >= top + 30 && mouseY <= top + 59) {
                this.func_146279_a(I18n.func_135052_a((String)"roads.gui.compactor.size", (Object[])new Object[0]), mouseX - left, mouseY - top + 15);
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiTextures);
        int left = (this.field_146294_l - this.field_146999_f) / 2;
        int top = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(left, top, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.electric) {
            this.func_73729_b(left + this.field_146999_f - 25, top, 176, 0, 25, this.field_147000_g);
        }
        this.drawFuel(left, top);
        this.drawProgress(left, top);
    }

    private void drawFuel(int left, int top) {
        if (this.electric) {
            CompactorElectricEntity cee = (CompactorElectricEntity)this.tileEntity;
            int p = this.getPercentage(cee.energy.getEnergyStored(), cee.energy.getMaxEnergyStored());
            int x = Math.round((float)p / 2.5f);
            if (p == 100) {
                x = 42;
            }
            this.func_73729_b(left + 155, top + 7 + (42 - x), 242, 42 - x, 14, x);
        } else {
            int p = this.getPercentage(this.tileEntity.fuel_remaining, this.tileEntity.last_fuel_cap);
            int x = Math.round((float)p / 7.0f);
            this.func_73729_b(left + 153, top + 15 + (14 - x), 229, 14 - x, 13, x);
        }
    }

    private void drawProgress(int left, int top) {
        int p = this.getPercentage(this.tileEntity.timerCount, this.electric ? RoadsConfig.machine.electricCompactorTickRate : RoadsConfig.machine.compactorTickRate);
        int x = Math.round((float)p * 1.6f);
        this.func_73729_b(left + 8, top + 54, 0, 252, x, 4);
    }

    private int getPercentage(int num, int max) {
        float x = (float)num / (float)max;
        int y = Math.round(x * 100.0f);
        if (y > 100) {
            return 100;
        }
        return y;
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.increase) {
            FurenikusRoads.PACKET_CHANNEL.sendToServer((IMessage)new CompactorUpdatePacket(1));
        }
        if (button == this.decrease) {
            FurenikusRoads.PACKET_CHANNEL.sendToServer((IMessage)new CompactorUpdatePacket(-1));
        }
    }
}

