/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.tileentities.tarmaccutter;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.blocks.tileentities.SlotFuel;
import com.silvaniastudios.roads.blocks.tileentities.SlotOutput;
import com.silvaniastudios.roads.blocks.tileentities.tarmaccutter.SlotBlade;
import com.silvaniastudios.roads.blocks.tileentities.tarmaccutter.SlotTarmacCutter;
import com.silvaniastudios.roads.blocks.tileentities.tarmaccutter.TarmacCutterElectricEntity;
import com.silvaniastudios.roads.blocks.tileentities.tarmaccutter.TarmacCutterEntity;
import com.silvaniastudios.roads.network.ClientGuiUpdatePacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TarmacCutterContainer
extends Container {
    public TarmacCutterEntity tileEntity;
    public static final int INPUT = 0;
    public static final int BLADE = 1;
    public static final int OUTPUT_1 = 2;
    public static final int OUTPUT_2 = 3;
    public static final int FUEL = 4;
    private boolean isElectric = false;
    private int energy;
    private int tick;
    private int fuel;
    private int fuelCap;

    public TarmacCutterContainer(InventoryPlayer invPlayer, TarmacCutterEntity tileEntity, boolean isElectric) {
        this.tileEntity = tileEntity;
        IItemHandler itemHandler = (IItemHandler)this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        this.func_75146_a((Slot)new SlotTarmacCutter(itemHandler, 0, 8, 32));
        this.func_75146_a((Slot)new SlotBlade(itemHandler, 1, 53, 32));
        this.func_75146_a((Slot)new SlotOutput(itemHandler, 2, 98, 32));
        this.func_75146_a((Slot)new SlotOutput(itemHandler, 3, 116, 32));
        if (!isElectric) {
            this.func_75146_a((Slot)new SlotFuel(itemHandler, 4, 152, 32));
        }
        this.isElectric = isElectric;
        this.addPlayerSlots((IInventory)invPlayer);
    }

    private void addPlayerSlots(IInventory playerInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                int x = 8 + j * 18;
                int y = i * 18 + 64;
                this.func_75146_a(new Slot(playerInventory, j + i * 9 + 9, x, y));
            }
        }
        for (i = 0; i < 9; ++i) {
            int x = 8 + i * 18;
            int y = 122;
            this.func_75146_a(new Slot(playerInventory, i, x, y));
        }
    }

    public void func_75142_b() {
        TarmacCutterElectricEntity tcee = null;
        if (this.isElectric) {
            tcee = (TarmacCutterElectricEntity)this.tileEntity;
        }
        super.func_75142_b();
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            IContainerListener listener = (IContainerListener)this.field_75149_d.get(i);
            if (!(listener instanceof EntityPlayer)) continue;
            if (tcee != null && this.energy != tcee.energy.getEnergyStored()) {
                FurenikusRoads.PACKET_CHANNEL.sendTo((IMessage)new ClientGuiUpdatePacket(0, tcee.energy.getEnergyStored()), (EntityPlayerMP)listener);
            }
            if (this.tick != this.tileEntity.timerCount) {
                listener.func_71112_a((Container)this, 10, this.tileEntity.timerCount);
            }
            if (this.fuel != this.tileEntity.fuel_remaining) {
                listener.func_71112_a((Container)this, 11, this.tileEntity.fuel_remaining);
            }
            if (this.fuelCap == this.tileEntity.last_fuel_cap) continue;
            listener.func_71112_a((Container)this, 12, this.tileEntity.last_fuel_cap);
        }
        if (tcee != null) {
            this.energy = tcee.energy.getEnergyStored();
        }
        this.tick = this.tileEntity.timerCount;
        this.fuel = this.tileEntity.fuel_remaining;
        this.fuelCap = this.tileEntity.last_fuel_cap;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        FurenikusRoads.debug(1, "Tarmac Cutter syncing ID: " + id + ", data: " + data);
        if (id == 10) {
            this.tileEntity.timerCount = data;
        }
        if (id == 11) {
            this.tileEntity.fuel_remaining = data;
        }
        if (id == 12) {
            this.tileEntity.last_fuel_cap = data;
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.tileEntity.canInteractWith(playerIn);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotId) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotId);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack1 = slot.func_75211_c();
            stack = stack1.func_77946_l();
            if (slotId < this.tileEntity.inventory.getSlots() ? !this.func_75135_a(stack1, this.tileEntity.inventory.getSlots(), this.field_75151_b.size(), true) : !this.func_75135_a(stack1, 0, this.tileEntity.inventory.getSlots(), false)) {
                return ItemStack.field_190927_a;
            }
            if (stack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return stack;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        this.tileEntity.sendUpdates();
        super.func_75134_a(playerIn);
    }
}

