/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.tileentities.recipes;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.items.ItemStackHandler;

public class TarDistillerRecipes {
    private final Ingredient ingredient;
    private final FluidStack fluidInput;
    private final FluidStack fluidOutput1;
    private final FluidStack fluidOutput2;
    private final ItemStack input;
    private final ItemStack output1;
    private final ItemStack output2;

    public TarDistillerRecipes(FluidStack fluidInput, ItemStack input, FluidStack fluidOutput1, FluidStack fluidOutput2, ItemStack output1, ItemStack output2) {
        this.ingredient = CraftingHelper.getIngredient((Object)input);
        this.fluidInput = fluidInput;
        this.input = input;
        this.fluidOutput1 = fluidOutput1;
        this.fluidOutput2 = fluidOutput2;
        this.output1 = output1;
        this.output2 = output2;
    }

    public boolean matches(InventoryCrafting inv, World worldIn) {
        return this.ingredient.test((Object)inv.func_70301_a(0));
    }

    public boolean test(Ingredient ing, ItemStack input) {
        if (input == ItemStack.field_190927_a) {
            return ing.test((Object)input);
        }
        return ing.test((Object)input) && this.input.func_190916_E() <= input.func_190916_E();
    }

    public boolean testFluid(FluidStack fluidIn) {
        if (this.fluidInput == null) {
            return true;
        }
        if (fluidIn == null) {
            return false;
        }
        return fluidIn.getFluid() == this.fluidInput.getFluid() && fluidIn.amount >= this.fluidInput.amount;
    }

    public boolean testFluidOutput(FluidStack tank, FluidStack recipeOut) {
        if (tank == null || recipeOut == null) {
            return true;
        }
        return tank.getFluid() == recipeOut.getFluid() && tank.amount + recipeOut.amount <= 320000;
    }

    public boolean canFullyCraft(ItemStackHandler inventory, FluidTank fluidIn, FluidTank fluidOut1, FluidTank fluidOut2) {
        ItemStack in = inventory.getStackInSlot(0);
        if (this.test(this.ingredient, in) && this.testFluid(fluidIn.getFluid())) {
            boolean out1;
            boolean bl = this.output1.func_190916_E() > 0 ? inventory.insertItem(1, this.output1, true).func_190916_E() == 0 : (out1 = true);
            boolean out2 = this.output2.func_190916_E() > 0 ? inventory.insertItem(2, this.output2, true).func_190916_E() == 0 : true;
            boolean fOut1 = this.testFluidOutput(fluidOut1.getFluid(), this.fluidOutput1);
            boolean fOut2 = this.testFluidOutput(fluidOut2.getFluid(), this.fluidOutput2);
            if (out1 && out2 && fOut1 && fOut2) {
                return true;
            }
        }
        return false;
    }

    public void processCrafting(ItemStackHandler inventory, FluidTank fluidIn, FluidTank fluidOut1, FluidTank fluidOut2) {
        if (this.canFullyCraft(inventory, fluidIn, fluidOut1, fluidOut2)) {
            if (this.input != ItemStack.field_190927_a) {
                inventory.extractItem(0, this.input.func_190916_E(), false);
            }
            if (this.fluidInput != null) {
                fluidIn.drain(this.fluidInput.amount, true);
            }
            if (this.output1 != ItemStack.field_190927_a) {
                inventory.insertItem(1, this.output1.func_77946_l(), false);
            }
            if (this.output2 != ItemStack.field_190927_a) {
                inventory.insertItem(2, this.output2.func_77946_l(), false);
            }
            if (this.fluidOutput1 != null) {
                fluidOut1.fill(this.fluidOutput1, true);
            }
            if (this.fluidOutput2 != null) {
                fluidOut2.fill(this.fluidOutput2, true);
            }
        }
    }

    public FluidStack getFluidInputStack() {
        return this.fluidInput;
    }

    public ItemStack getInputStack() {
        return this.input;
    }

    public ItemStack getOutput1Stack() {
        return this.output1;
    }

    public ItemStack getOutput2Stack() {
        return this.output2;
    }

    public FluidStack getFluidOutput1Stack() {
        return this.fluidOutput1;
    }

    public FluidStack getFluidOutput2Stack() {
        return this.fluidOutput2;
    }
}

