/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.tileentities.paintoven;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.blocks.tileentities.RoadTEBlock;
import com.silvaniastudios.roads.blocks.tileentities.RoadTileEntity;
import com.silvaniastudios.roads.blocks.tileentities.paintoven.PaintOvenElectricEntity;
import com.silvaniastudios.roads.blocks.tileentities.paintoven.PaintOvenEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PaintOvenBlock
extends RoadTEBlock {
    public PaintOvenBlock(String name, boolean electric) {
        super(name, electric, 11);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ROTATION, (Comparable)((Object)RoadTEBlock.EnumRotation.north)).func_177226_a((IProperty)FURNACE_ACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BASE_PLATE, (Comparable)Boolean.valueOf(true)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"roads.gui.paint_oven.tooltip_1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"roads.gui.paint_oven.tooltip_2", (Object[])new Object[0]));
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        PaintOvenEntity te;
        ItemStack held = player.func_184586_b(EnumHand.MAIN_HAND);
        if (held.func_77973_b() == Items.field_151133_ar && world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof PaintOvenEntity) {
            te = (PaintOvenEntity)world.func_175625_s(pos);
            if (te.paint.getFluidAmount() >= 1000) {
                if (!player.func_184812_l_()) {
                    if (held.func_190916_E() > 1) {
                        held.func_190920_e(held.func_190916_E() - 1);
                    } else {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                    }
                }
                player.func_191521_c(FluidUtil.getFilledBucket((FluidStack)te.paint.getFluid()));
                te.paint.drain(1000, true);
                te.sendUpdates();
                return true;
            }
        }
        if (held.func_77973_b() == Items.field_151131_as && world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof PaintOvenEntity) {
            te = (PaintOvenEntity)world.func_175625_s(pos);
            if (te.water.getFluidAmount() + 1000 <= 64000) {
                if (!player.func_184812_l_()) {
                    if (held.func_190916_E() > 1) {
                        held.func_190920_e(held.func_190916_E() - 1);
                    } else {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                    }
                    player.func_191521_c(new ItemStack(Items.field_151133_ar));
                }
                if (te.water.getFluidAmount() > 0) {
                    te.water.fill(new FluidStack(te.water.getFluid().getFluid(), 1000), true);
                } else {
                    te.water.setFluid(new FluidStack(FluidRegistry.WATER, 1000));
                }
                te.sendUpdates();
                return true;
            }
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        if (this.electric) {
            return new PaintOvenElectricEntity();
        }
        return new PaintOvenEntity();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)FURNACE_ACTIVE, (Comparable)Boolean.valueOf(this.isFurnaceEnabled(state, world, pos))).func_177226_a((IProperty)BASE_PLATE, (Comparable)Boolean.valueOf(this.hasBasePlate(world, pos)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION, FURNACE_ACTIVE, BASE_PLATE});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        int meta = this.func_176201_c(state);
        if (meta == 0) {
            return new AxisAlignedBB(0.125, 0.0, 0.0, 0.875, 1.0, 0.84375);
        }
        if (meta == 1) {
            return new AxisAlignedBB(0.15625, 0.0, 0.125, 1.0, 1.0, 0.875);
        }
        if (meta == 2) {
            return new AxisAlignedBB(0.125, 0.0, 0.15625, 0.875, 1.0, 1.0);
        }
        if (meta == 3) {
            return new AxisAlignedBB(0.0, 0.0, 0.125, 0.84375, 1.0, 0.875);
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_185496_a(state, world, pos);
    }

    @Override
    public void openGui(World world, BlockPos pos, EntityPlayer player) {
        TileEntity te = world.func_175625_s(pos);
        if (!world.field_72995_K && te != null && te instanceof RoadTileEntity) {
            player.openGui((Object)FurenikusRoads.instance, this.electric ? 12 : 11, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }
}

