/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.tileentities.fabricator;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.tileentities.RoadTileEntity;
import com.silvaniastudios.roads.blocks.tileentities.fabricator.FabricatorContainer;
import com.silvaniastudios.roads.blocks.tileentities.fabricator.FabricatorStackHandler;
import com.silvaniastudios.roads.blocks.tileentities.recipes.FabricatorRecipes;
import com.silvaniastudios.roads.blocks.tileentities.recipes.RecipeRegistry;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class FabricatorEntity
extends RoadTileEntity
implements ITickable,
ICapabilityProvider {
    public int timerCount = 0;
    public int recipeId = 0;
    public ItemStackHandler inventory = new ItemStackHandler(8){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot != 6;
        }
    };
    public FabricatorStackHandler interactable_inv = new FabricatorStackHandler(this.inventory, this.hasCapability(CapabilityEnergy.ENERGY, null));

    public Container createContainer(EntityPlayer player) {
        return new FabricatorContainer(player.field_71071_by, this, false);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getCapability(capability, facing) != null;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing != null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.interactable_inv);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (this.fuel_remaining > 0) {
            --this.fuel_remaining;
        } else if (this.fuel_remaining <= 0) {
            if (!this.inventory.getStackInSlot(7).func_190926_b()) {
                this.last_fuel_cap = this.fuel_remaining = TileEntityFurnace.func_145952_a((ItemStack)this.inventory.getStackInSlot(7));
                if (this.inventory.getStackInSlot(7).func_77973_b() == Items.field_151129_at) {
                    this.inventory.setStackInSlot(7, new ItemStack(Items.field_151133_ar));
                } else {
                    this.inventory.extractItem(7, 1, false);
                }
                this.sendUpdates();
            } else {
                this.timerCount = 0;
            }
        }
        if (this.timerCount < RoadsConfig.machine.fabricatorTickRate && this.fuel_remaining > 0) {
            this.timerCount = this.shouldTick() ? ++this.timerCount : 0;
        } else {
            if (this.fuel_remaining > 0) {
                this.process();
            }
            this.timerCount = 0;
        }
    }

    public boolean shouldTick() {
        for (int i = 0; i < RecipeRegistry.fabricatorRecipes.size(); ++i) {
            FabricatorRecipes recipe = RecipeRegistry.fabricatorRecipes.get(i);
            ItemStack result = recipe.getCraftingResult(this.inventory, this.recipeId);
            if (result == ItemStack.field_190927_a || this.inventory.insertItem(6, result, true) != ItemStack.field_190927_a) continue;
            return true;
        }
        return false;
    }

    public void process() {
        FurenikusRoads.debug(2, "Fabricator at" + this.formatPosition(this.field_174879_c) + "processing");
        for (int i = 0; i < RecipeRegistry.fabricatorRecipes.size(); ++i) {
            FabricatorRecipes recipe = RecipeRegistry.fabricatorRecipes.get(i);
            recipe.processRecipe(this.inventory, this.recipeId);
        }
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        this.fuel_remaining = nbt.func_74762_e("fuel");
        this.last_fuel_cap = nbt.func_74762_e("fuel_last_used");
        this.recipeId = nbt.func_74762_e("recipeId");
        if (nbt.func_74764_b("items")) {
            this.inventory.deserializeNBT((NBTTagCompound)nbt.func_74781_a("items"));
        }
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("fuel", this.fuel_remaining);
        nbt.func_74768_a("fuel_last_used", this.last_fuel_cap);
        nbt.func_74768_a("recipeId", this.recipeId);
        nbt.func_74782_a("items", (NBTBase)this.inventory.serializeNBT());
        return nbt;
    }
}

