/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.paint.customs;

import com.google.common.base.Predicate;
import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.blocks.PaintColour;
import com.silvaniastudios.roads.blocks.enums.IMetaBlockName;
import com.silvaniastudios.roads.blocks.paint.PaintBlockCustomRenderBase;
import com.silvaniastudios.roads.blocks.paint.customs.ICustomBlock;
import com.silvaniastudios.roads.blocks.paint.properties.PaintGrid;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CustomPaintBlock
extends PaintBlockCustomRenderBase
implements IMetaBlockName,
ICustomBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private PaintGrid[] paintGrids;
    private String localizedName;
    private boolean isInternal = false;
    private EnumPaintType paintType;

    public CustomPaintBlock(String name, String localName, EnumPaintType paintType, PaintGrid[] grids, String category, int[] subBlocks, PaintColour colour) {
        super(name, category, subBlocks, false, colour);
        this.paintGrids = grids;
        this.localizedName = localName;
        this.paintType = paintType;
        this.func_149647_a(FurenikusRoads.tab_paint_customs);
    }

    public CustomPaintBlock(String name, EnumPaintType paintType, PaintGrid[] grids, String category, int[] subBlocks, PaintColour colour, CreativeTabs tab) {
        super(name, category, subBlocks, false, colour);
        this.paintGrids = grids;
        this.paintType = paintType;
        this.func_149647_a(tab);
        this.isInternal = true;
    }

    public String getInternalName() {
        return this.name;
    }

    @Override
    public PaintGrid getGrid(int id) {
        return this.paintGrids[id];
    }

    public String getLocalName() {
        return this.localizedName;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public EnumPaintType getPaintType() {
        return this.paintType;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing == EnumFacing.DOWN || enumfacing == EnumFacing.UP) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public static enum EnumPaintType implements IStringSerializable
    {
        ICON_1x1("icon_1x1"),
        WALL_ICON_1x1("wall_icon_1x1"),
        MULTI_2x1("multi_2x1"),
        MULTI_3x1("multi_3x1"),
        MULTI_4x1("multi_4x1"),
        LARGE_TEXT("large_text");

        private final String name;

        private EnumPaintType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static EnumPaintType getFromString(String in) {
            if (in.equalsIgnoreCase(ICON_1x1.func_176610_l()) || in.equalsIgnoreCase("1x1")) {
                return ICON_1x1;
            }
            if (in.equalsIgnoreCase(WALL_ICON_1x1.func_176610_l())) {
                return WALL_ICON_1x1;
            }
            if (in.equalsIgnoreCase(MULTI_2x1.func_176610_l())) {
                return MULTI_2x1;
            }
            if (in.equalsIgnoreCase(MULTI_3x1.func_176610_l())) {
                return MULTI_3x1;
            }
            if (in.equalsIgnoreCase(MULTI_4x1.func_176610_l())) {
                return MULTI_4x1;
            }
            if (in.equalsIgnoreCase(LARGE_TEXT.func_176610_l())) {
                return LARGE_TEXT;
            }
            return ICON_1x1;
        }
    }
}

