/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.paint;

import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.BlockBase;
import com.silvaniastudios.roads.blocks.FRBlocks;
import com.silvaniastudios.roads.blocks.NonPaintRoadTopBlock;
import com.silvaniastudios.roads.blocks.PaintColour;
import com.silvaniastudios.roads.blocks.decorative.CurbBlock;
import com.silvaniastudios.roads.blocks.diagonal.RoadBlockDiagonal;
import com.silvaniastudios.roads.items.FRItems;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PaintBlockBase
extends BlockBase {
    private String categoryName;
    private int[] coreMetas;
    protected boolean[] dynamic;
    private PaintColour colour;

    public PaintBlockBase(String name, String catName, int[] coreMetas, boolean[] dynamic, PaintColour colour) {
        super(name, Material.field_151580_n);
        this.categoryName = catName;
        this.coreMetas = coreMetas;
        this.func_149711_c(2.0f);
        this.dynamic = dynamic;
        this.colour = colour;
    }

    public PaintBlockBase(String name, String catName, int[] coreMetas, boolean dynamic, PaintColour colour) {
        this(name, catName, coreMetas, null, colour);
        if (coreMetas != null) {
            this.dynamic = new boolean[coreMetas.length];
            if (dynamic) {
                Arrays.fill(this.dynamic, true);
            }
        }
    }

    public PaintColour getColour() {
        return this.colour;
    }

    public String getCategory() {
        return this.categoryName;
    }

    public int[] getCoreMetas() {
        return this.coreMetas;
    }

    public boolean canConnect(int id) {
        return this.dynamic[id];
    }

    public String getIconName() {
        for (int i = 0; i < FRBlocks.col.size(); ++i) {
            if (this.name.contains(FRBlocks.col.get(i).getName() + "_")) {
                return this.name.replace(FRBlocks.col.get(i).getName() + "_", "");
            }
            if (!this.name.contains("_" + FRBlocks.col.get(i).getName())) continue;
            return this.name.replace("_" + FRBlocks.col.get(i).getName(), "");
        }
        return "";
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemStack.field_190927_a.func_77973_b();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int closest = 0;
        if (this.getCoreMetas() == null) {
            return new ItemStack((Block)this, 1, 0);
        }
        for (int i = 0; i < this.getCoreMetas().length; ++i) {
            if (this.getCoreMetas()[i] > this.func_176201_c(state) || this.getCoreMetas()[i] <= closest) continue;
            closest = this.getCoreMetas()[i];
        }
        return new ItemStack((Block)this, 1, closest);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < this.getCoreMetas().length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, this.getCoreMetas()[i]));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Item item = player.func_184586_b(hand).func_77973_b();
        if (item.equals((Object)FRItems.paint_scraper)) {
            world.func_175698_g(pos);
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (world.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_177230_c() instanceof BlockAir && RoadsConfig.general.breakPaintOnBlockBreak) {
            world.func_175698_g(pos);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0, -1.0 + this.getBlockBelowHeight(source, pos), 0.0, 1.0, -1.0 + this.getBlockBelowHeight(source, pos) + 0.0625, 1.0);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XYZ;
    }

    public Vec3d func_190949_e(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        double offset = 1.0 - this.getBlockBelowHeight(worldIn, pos);
        return new Vec3d(0.0, -offset, 0.0);
    }

    public double getBlockBelowHeight(IBlockAccess worldIn, BlockPos pos) {
        IBlockState underState = worldIn.func_180495_p(pos.func_177972_a(EnumFacing.DOWN));
        Block underBlock = underState.func_177230_c();
        double extraOffset = 0.0;
        if (underBlock instanceof RoadBlockDiagonal) {
            RoadBlockDiagonal rbd = (RoadBlockDiagonal)underBlock;
            return rbd.getBlockHeight(worldIn, rbd.getRoad(worldIn, pos.func_177972_a(EnumFacing.DOWN)), rbd.getRoadPos(worldIn, pos.func_177972_a(EnumFacing.DOWN)));
        }
        if (underBlock instanceof PaintBlockBase || underBlock instanceof NonPaintRoadTopBlock || underBlock instanceof CurbBlock) {
            extraOffset = 0.062;
        }
        return underBlock.func_185496_a((IBlockState)underState, (IBlockAccess)worldIn, (BlockPos)pos.func_177972_a((EnumFacing)EnumFacing.DOWN)).field_72337_e - extraOffset;
    }
}

