/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.diagonal;

import com.silvaniastudios.roads.blocks.diagonal.HalfBlock;
import com.silvaniastudios.roads.blocks.paint.properties.PaintGrid;
import com.silvaniastudios.roads.client.render.Quad;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.math.Vec3d;

public class ShapeLibrary {
    public static List<Quad> shapeFromGrid(boolean[][] grid, float top, TextureAtlasSprite sprite, VertexFormat format, boolean drawBottom) {
        return ShapeLibrary.shapeFromGrid(grid, top, sprite, format, drawBottom, 1.0f);
    }

    public static List<Quad> shapeFromGrid(boolean[][] grid, float top, TextureAtlasSprite sprite, VertexFormat format, boolean drawBottom, float scale) {
        ArrayList<Quad> quads = new ArrayList<Quad>();
        float p = scale / (float)grid.length;
        float p2 = scale / 64.0f;
        for (int i = 0; i < grid.length; ++i) {
            for (int j = 0; j < grid[i].length; ++j) {
                if (!grid[j][i]) continue;
                if (i == 0 || i - 1 >= 0 && !grid[j][i - 1]) {
                    quads.add(new Quad(new Vec3d((double)((float)j * p + p), (double)(top - p2), (double)((float)i * p)), 0.0f, 0.5f, new Vec3d((double)((float)j * p), (double)(top - p2), (double)((float)i * p)), 0.5f, 0.5f, new Vec3d((double)((float)j * p), (double)top, (double)((float)i * p)), 0.5f, 0.0f, new Vec3d((double)((float)j * p + p), (double)top, (double)((float)i * p)), 0.0f, 0.0f, sprite, format));
                }
                if (j + 1 == grid.length || j + 1 < grid.length && !grid[j + 1][i]) {
                    quads.add(new Quad(new Vec3d((double)((float)j * p + p), (double)(top - p2), (double)((float)i * p + p)), 0.0f, 0.5f, new Vec3d((double)((float)j * p + p), (double)(top - p2), (double)((float)i * p)), 0.5f, 0.5f, new Vec3d((double)((float)j * p + p), (double)top, (double)((float)i * p)), 0.5f, 0.0f, new Vec3d((double)((float)j * p + p), (double)top, (double)((float)i * p + p)), 0.0f, 0.0f, sprite, format));
                }
                if (i + 1 == grid.length || i + 1 < grid.length && !grid[j][i + 1]) {
                    quads.add(new Quad(new Vec3d((double)((float)j * p), (double)(top - p2), (double)((float)i * p + p)), 0.0f, 0.5f, new Vec3d((double)((float)j * p + p), (double)(top - p2), (double)((float)i * p + p)), 0.5f, 0.5f, new Vec3d((double)((float)j * p + p), (double)top, (double)((float)i * p + p)), 0.5f, 0.0f, new Vec3d((double)((float)j * p), (double)top, (double)((float)i * p + p)), 0.0f, 0.0f, sprite, format));
                }
                if (j == 0 || j - 1 >= 0 && !grid[j - 1][i]) {
                    quads.add(new Quad(new Vec3d((double)((float)j * p), (double)(top - p2), (double)((float)i * p)), 0.0f, 0.5f, new Vec3d((double)((float)j * p), (double)(top - p2), (double)((float)i * p + p)), 0.5f, 0.5f, new Vec3d((double)((float)j * p), (double)top, (double)((float)i * p + p)), 0.5f, 0.0f, new Vec3d((double)((float)j * p), (double)top, (double)((float)i * p)), 0.0f, 0.0f, sprite, format));
                }
                quads.add(new Quad(new Vec3d((double)((float)j * p), (double)top, (double)((float)i * p + p)), new Vec3d((double)((float)j * p + p), (double)top, (double)((float)i * p + p)), new Vec3d((double)((float)j * p + p), (double)top, (double)((float)i * p)), new Vec3d((double)((float)j * p), (double)top, (double)((float)i * p)), sprite, format));
                if (!drawBottom) continue;
                quads.add(new Quad(new Vec3d((double)((float)j * p + p), (double)(top - p2), (double)((float)i * p + p)), new Vec3d((double)((float)j * p), (double)(top - p2), (double)((float)i * p + p)), new Vec3d((double)((float)j * p), (double)(top - p2), (double)((float)i * p)), new Vec3d((double)((float)j * p + p), (double)(top - p2), (double)((float)i * p)), sprite, format));
            }
        }
        return quads;
    }

    public static List<Quad> shapeFromGridFlat(boolean[][] grid, float xMin, float xMax, float yMin, float yMax, float zMin, float zMax, TextureAtlasSprite sprite) {
        sprite.func_110968_a(null);
        ArrayList<Quad> quads = new ArrayList<Quad>();
        float deltaX = xMax - xMin;
        float deltaY = yMax - yMin;
        float deltaZ = zMax - zMin;
        float x = deltaX / (float)grid.length;
        float y = deltaY / (float)grid.length;
        float z = deltaZ / (float)grid.length;
        for (int i = 0; i < grid.length; ++i) {
            for (int j = 0; j < grid[i].length; ++j) {
                if (!grid[j][i]) continue;
                quads.add(new Quad(new Vec3d((double)(xMin + x * (float)j + x), (double)(yMax - (float)i * y), (double)(zMin + z * (float)i)), new Vec3d((double)(xMin + x * (float)j), (double)(yMax - (float)i * y), (double)(zMin + z * (float)i)), new Vec3d((double)(xMin + x * (float)j), (double)(yMax - (float)i * y - y), (double)(zMin + z * (float)i + z)), new Vec3d((double)(xMin + x * (float)j + x), (double)(yMax - (float)i * y - y), (double)(zMin + z * (float)i + z)), sprite, DefaultVertexFormats.field_176599_b));
            }
        }
        return quads;
    }

    public static List<Quad> shapeTriangleLeft(HalfBlock block, double width, VertexFormat format) {
        ArrayList<Quad> quads = new ArrayList<Quad>();
        float height = block.getHeight();
        TextureAtlasSprite sprite = block.getSprite();
        Quad top = null;
        Quad bottom = null;
        Quad north = null;
        Quad east = null;
        if (block.renderTop()) {
            if (block.isFluid()) {
                top = new Quad(new Vec3d(0.0, (double)block.heightSW(), 0.5), new Vec3d(0.0, (double)block.heightSE(), 1.0), new Vec3d(1.0 - width, (double)block.heightNE(), 0.0), new Vec3d(0.0, (double)block.heightNW(), 0.0), sprite, format);
                bottom = new Quad(new Vec3d(0.0, (double)block.heightSW(), 0.0), new Vec3d(1.0 - width, (double)block.heightNW(), 0.0), new Vec3d(0.0, (double)block.heightNE(), 1.0), new Vec3d(0.0, (double)block.heightSE(), 0.5), sprite, format);
            } else {
                top = new Quad(new Vec3d(0.0, (double)height, 0.5), new Vec3d(0.0, (double)height, 1.0), new Vec3d(1.0 - width, (double)height, 0.0), new Vec3d(0.0, (double)height, 0.0), sprite, format);
            }
        }
        if (block.renderBottom()) {
            bottom = new Quad(new Vec3d(0.0, 0.0, 0.0), new Vec3d(1.0 - width, 0.0, 0.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 0.5), sprite, format);
        }
        if (block.renderNear()) {
            north = new Quad(new Vec3d(1.0 - width, (double)height, 0.0), (float)width * 16.0f, 16.0f - height * 16.0f, new Vec3d(1.0 - width, 0.0, 0.0), (float)width * 16.0f, 16.0f, new Vec3d(0.0, 0.0, 0.0), 16.0f, 16.0f, new Vec3d(0.0, (double)height, 0.0), 16.0f, 16.0f - height * 16.0f, sprite, format);
        }
        if (block.renderDivision()) {
            east = new Quad(new Vec3d(0.0, (double)height, 1.0), 0.0f, 16.0f - height * 16.0f, new Vec3d(0.0, 0.0, 1.0), 0.0f, 16.0f, new Vec3d(1.0 - width, 0.0, 0.0), 16.0f, 16.0f, new Vec3d(1.0 - width, (double)height, 0.0), 16.0f, 16.0f - height * 16.0f, sprite, format);
        }
        quads.add(top);
        quads.add(bottom);
        quads.add(north);
        quads.add(east);
        return quads;
    }

    public static List<Quad> shapeTriangleRight(HalfBlock block, double width, VertexFormat format) {
        ArrayList<Quad> quads = new ArrayList<Quad>();
        float height = block.getHeight();
        TextureAtlasSprite sprite = block.getSprite();
        Quad top = null;
        Quad bottom = null;
        Quad north = null;
        Quad east = null;
        if (block.renderTop()) {
            if (block.isFluid()) {
                top = new Quad(new Vec3d(0.0, (double)block.heightSW(), 0.5), new Vec3d(0.0, (double)block.heightSE(), 1.0), new Vec3d(1.0 - width, (double)block.heightNE(), 1.0), new Vec3d(0.0, (double)block.heightNW(), 0.0), sprite, format);
                bottom = new Quad(new Vec3d(1.0 - width, (double)block.heightSW(), 1.0), new Vec3d(0.0, (double)block.heightNW(), 1.0), new Vec3d(0.0, (double)block.heightNE(), 0.5), new Vec3d(0.0, (double)block.heightSE(), 0.0), sprite, format);
            } else {
                top = new Quad(new Vec3d(0.0, (double)height, 0.5), new Vec3d(0.0, (double)height, 1.0), new Vec3d(1.0 - width, (double)height, 1.0), new Vec3d(0.0, (double)height, 0.0), sprite, format);
            }
        }
        if (block.renderBottom()) {
            bottom = new Quad(new Vec3d(1.0 - width, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 0.5), new Vec3d(0.0, 0.0, 0.0), sprite, format);
        }
        if (block.renderFarMirrored()) {
            north = new Quad(new Vec3d(0.0, (double)height, 1.0), 0.0f, 16.0f - height * 16.0f, new Vec3d(0.0, 0.0, 1.0), 0.0f, 16.0f, new Vec3d(1.0 - width, 0.0, 1.0), (float)width * 16.0f, 16.0f, new Vec3d(1.0 - width, (double)height, 1.0), (float)width * 16.0f, 16.0f - height * 16.0f, sprite, format);
        }
        if (block.renderDivision()) {
            east = new Quad(new Vec3d(1.0 - width, (double)height, 1.0), 0.0f, 16.0f - height * 16.0f, new Vec3d(1.0 - width, 0.0, 1.0), 0.0f, 16.0f, new Vec3d(0.0, 0.0, 0.0), 16.0f, 16.0f, new Vec3d(0.0, (double)height, 0.0), 16.0f, 16.0f - height * 16.0f, sprite, format);
        }
        quads.add(top);
        quads.add(bottom);
        quads.add(north);
        quads.add(east);
        return quads;
    }

    public static List<Quad> shapeTrapeziumLeft(HalfBlock block, double widthN, double widthW, VertexFormat format) {
        ArrayList<Quad> quads = new ArrayList<Quad>();
        float height = block.getHeight();
        TextureAtlasSprite sprite = block.getSprite();
        Quad top = null;
        Quad bottom = null;
        Quad south = null;
        Quad north = null;
        Quad front = null;
        if (block.renderTop()) {
            if (block.isFluid()) {
                top = new Quad(new Vec3d(0.0, (double)block.heightSW(), 1.0), new Vec3d(widthN, (double)block.heightSE(), 1.0), new Vec3d(widthW, (double)block.heightNE(), 0.0), new Vec3d(0.0, (double)block.heightNW(), 0.0), sprite, format);
                bottom = new Quad(new Vec3d(widthN, (double)block.heightSW(), 1.0), new Vec3d(0.0, (double)block.heightNW(), 1.0), new Vec3d(0.0, (double)block.heightNE(), 0.0), new Vec3d(widthW, (double)block.heightSE(), 0.0), sprite, format);
            } else {
                top = new Quad(new Vec3d(0.0, (double)height, 1.0), new Vec3d(widthN, (double)height, 1.0), new Vec3d(widthW, (double)height, 0.0), new Vec3d(0.0, (double)height, 0.0), sprite, format);
            }
        }
        if (block.renderBottom()) {
            bottom = new Quad(new Vec3d(widthN, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 0.0), new Vec3d(widthW, 0.0, 0.0), sprite, format);
        }
        if (block.renderFar()) {
            south = new Quad(new Vec3d(widthN, (double)height, 1.0), (float)(16.0 * widthN), 16.0f - 16.0f * height, new Vec3d(0.0, (double)height, 1.0), 0.0f, 16.0f - 16.0f * height, new Vec3d(0.0, 0.0, 1.0), 0.0f, 16.0f, new Vec3d(widthN, 0.0, 1.0), (float)(16.0 * widthN), 16.0f, sprite, format);
        }
        if (block.renderNear()) {
            north = new Quad(new Vec3d(widthW, 0.0, 0.0), 0.0f, 16.0f, new Vec3d(0.0, 0.0, 0.0), (float)(16.0 * widthW), 16.0f, new Vec3d(0.0, (double)height, 0.0), (float)(16.0 * widthW), 16.0f - 16.0f * height, new Vec3d(widthW, (double)height, 0.0), 0.0f, 16.0f - 16.0f * height, sprite, format);
        }
        if (block.renderDivision()) {
            front = new Quad(new Vec3d(widthN, 0.0, 1.0), 0.0f, 16.0f, new Vec3d(widthW, 0.0, 0.0), 16.0f, 16.0f, new Vec3d(widthW, (double)height, 0.0), 16.0f, 16.0f - height * 16.0f, new Vec3d(widthN, (double)height, 1.0), 0.0f, 16.0f - height * 16.0f, sprite, format);
        }
        quads.add(top);
        quads.add(bottom);
        quads.add(south);
        quads.add(north);
        quads.add(front);
        return quads;
    }

    public static List<Quad> shapeTrapeziumRight(HalfBlock block, double widthN, double widthW, VertexFormat format) {
        ArrayList<Quad> quads = new ArrayList<Quad>();
        float height = block.getHeight();
        TextureAtlasSprite sprite = block.getSprite();
        Quad top = null;
        Quad bottom = null;
        Quad south = null;
        Quad north = null;
        Quad front = null;
        if (block.renderTop()) {
            if (block.isFluid()) {
                top = new Quad(new Vec3d(0.0, (double)block.heightSW(), 1.0), new Vec3d(widthW, (double)block.heightSE(), 1.0), new Vec3d(widthN, (double)block.heightNE(), 0.0), new Vec3d(0.0, (double)block.heightNW(), 0.0), sprite, format);
                bottom = new Quad(new Vec3d(widthW, (double)block.heightSW(), 1.0), new Vec3d(0.0, (double)block.heightNW(), 1.0), new Vec3d(0.0, (double)block.heightNE(), 0.0), new Vec3d(widthN, (double)block.heightSE(), 0.0), sprite, format);
            } else {
                top = new Quad(new Vec3d(0.0, (double)height, 1.0), new Vec3d(widthW, (double)height, 1.0), new Vec3d(widthN, (double)height, 0.0), new Vec3d(0.0, (double)height, 0.0), sprite, format);
            }
        }
        if (block.renderBottom()) {
            bottom = new Quad(new Vec3d(widthW, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 0.0), new Vec3d(widthN, 0.0, 0.0), sprite, format);
        }
        if (block.renderFarMirrored()) {
            south = new Quad(new Vec3d(widthW, (double)height, 1.0), (float)(16.0 * widthW), 16.0f - 16.0f * height, new Vec3d(0.0, (double)height, 1.0), 0.0f, 16.0f - 16.0f * height, new Vec3d(0.0, 0.0, 1.0), 0.0f, 16.0f, new Vec3d(widthW, 0.0, 1.0), (float)(16.0 * widthW), 16.0f, sprite, format);
        }
        if (block.renderNearMirrored()) {
            north = new Quad(new Vec3d(widthN, 0.0, 0.0), 16.0f - (float)(16.0 * widthN), 16.0f, new Vec3d(0.0, 0.0, 0.0), 16.0f, 16.0f, new Vec3d(0.0, (double)height, 0.0), 16.0f, 16.0f - 16.0f * height, new Vec3d(widthN, (double)height, 0.0), 16.0f - (float)(16.0 * widthN), 16.0f - 16.0f * height, sprite, format);
        }
        if (block.renderDivision()) {
            front = new Quad(new Vec3d(widthW, 0.0, 1.0), 0.0f, 16.0f, new Vec3d(widthN, 0.0, 0.0), 16.0f, 16.0f, new Vec3d(widthN, (double)height, 0.0), 16.0f, 16.0f - height * 16.0f, new Vec3d(widthW, (double)height, 1.0), 0.0f, 16.0f - height * 16.0f, sprite, format);
        }
        quads.add(top);
        quads.add(bottom);
        quads.add(south);
        quads.add(north);
        quads.add(front);
        return quads;
    }

    public static BufferedImage getImageFromGrid(String name, PaintGrid grid, int id) throws IOException {
        BufferedImage image = new BufferedImage(grid.size(), grid.size(), 2);
        Color myWhite = new Color(255, 255, 255);
        int rgb = myWhite.getRGB();
        for (int i = 0; i < grid.size(); ++i) {
            for (int j = 0; j < grid.size(); ++j) {
                if (!grid.getGrid()[j][i]) continue;
                image.setRGB(j, i, rgb);
            }
        }
        File outputfile = new File(name + "_" + id + ".png");
        ImageIO.write((RenderedImage)image, "png", outputfile);
        return image;
    }
}

