/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.diagonal;

import com.silvaniastudios.roads.blocks.FRBlocks;
import com.silvaniastudios.roads.blocks.diagonal.RoadBlockDiagonal;
import java.util.List;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class HalfBlock {
    RoadBlockDiagonal block;
    private World world;
    private IBlockState stateSide;
    private List<BakedQuad> quadsSide;
    private BlockPos posSide;
    private HalfBlock partnerBlock;
    private float height = 0.0f;
    private BlockPos pos;
    private TextureAtlasSprite sprite;
    private int blockColour;
    private HalfBlockSide side;
    private EnumFacing facing;
    private boolean isFluid = false;

    public HalfBlock(IExtendedBlockState sharedState, HalfBlockSide side) {
        this(sharedState, side, (BlockPos)sharedState.getValue((IUnlistedProperty)RoadBlockDiagonal.POS), (EnumFacing)sharedState.func_177229_b(RoadBlockDiagonal.FACING));
    }

    public HalfBlock(IExtendedBlockState sharedState, HalfBlockSide side, BlockPos pos, EnumFacing facing, World world) {
        this.block = (RoadBlockDiagonal)sharedState.func_177230_c();
        sharedState = (IExtendedBlockState)this.block.getExtendedState((IBlockState)sharedState, (IBlockAccess)world, pos);
        this.side = side;
        this.pos = pos;
        this.facing = facing;
        this.world = world;
        if (side == HalfBlockSide.LEFT) {
            this.posSide = pos.func_177972_a(facing.func_176735_f());
            this.stateSide = (IBlockState)sharedState.getValue((IUnlistedProperty)RoadBlockDiagonal.LEFT);
        } else if (side == HalfBlockSide.RIGHT) {
            this.posSide = pos.func_177972_a(facing.func_176746_e());
            this.stateSide = (IBlockState)sharedState.getValue((IUnlistedProperty)RoadBlockDiagonal.RIGHT);
        }
        this.height = this.block.getSideHeight((IBlockState)sharedState, world, pos, side);
        if (this.stateSide.func_177230_c() instanceof BlockFluidBase) {
            this.isFluid = true;
        }
        if (this.stateSide.func_177230_c() instanceof BlockLiquid) {
            this.height = BlockLiquid.func_190973_f((IBlockState)this.stateSide, (IBlockAccess)world, (BlockPos)this.posSide);
        }
    }

    public HalfBlock(IExtendedBlockState sharedState, HalfBlockSide side, BlockPos pos, EnumFacing facing) {
        this.block = (RoadBlockDiagonal)sharedState.func_177230_c();
        this.world = Minecraft.func_71410_x().field_71441_e;
        Minecraft mc = Minecraft.func_71410_x();
        sharedState = (IExtendedBlockState)this.block.getExtendedState((IBlockState)sharedState, (IBlockAccess)this.world, pos);
        this.side = side;
        this.pos = pos;
        this.facing = facing;
        if (side == HalfBlockSide.LEFT) {
            this.posSide = pos.func_177972_a(facing.func_176735_f());
            this.stateSide = (IBlockState)sharedState.getValue((IUnlistedProperty)RoadBlockDiagonal.LEFT);
        } else if (side == HalfBlockSide.RIGHT) {
            this.posSide = pos.func_177972_a(facing.func_176746_e());
            this.stateSide = (IBlockState)sharedState.getValue((IUnlistedProperty)RoadBlockDiagonal.RIGHT);
        }
        this.height = this.block.getSideHeight((IBlockState)sharedState, this.world, pos, side);
        this.quadsSide = mc.func_175602_ab().func_184389_a(this.stateSide).func_188616_a(this.stateSide, EnumFacing.UP, 0L);
        TextureAtlasSprite textureAtlasSprite = this.sprite = this.height == 0.0f ? null : mc.func_175602_ab().func_184389_a(this.stateSide).func_177554_e();
        if (this.quadsSide.size() > 0 && this.height > 0.0f) {
            this.sprite = this.quadsSide.get(0).func_187508_a();
        }
        if (this.stateSide.func_177230_c() instanceof BlockGrass || this.stateSide.func_177230_c() instanceof BlockLeaves || this.stateSide.func_177230_c() == FRBlocks.road_block_grass) {
            this.blockColour = this.world.func_180494_b(this.posSide).func_180627_b(this.posSide);
        }
        if (this.stateSide.func_177230_c() instanceof BlockFluidBase) {
            this.isFluid = true;
        }
        if (this.stateSide.func_177230_c() instanceof BlockLiquid) {
            Fluid fluid = null;
            if (this.stateSide.func_185904_a() == Material.field_151586_h) {
                fluid = FluidRegistry.WATER;
            } else if (this.stateSide.func_185904_a() == Material.field_151587_i) {
                fluid = FluidRegistry.LAVA;
            }
            this.height = BlockLiquid.func_190973_f((IBlockState)this.stateSide, (IBlockAccess)this.world, (BlockPos)this.posSide);
            if (fluid != null) {
                this.sprite = mc.func_147117_R().func_110572_b(fluid.getStill(new FluidStack(fluid, 1000)).toString());
                this.isFluid = true;
            }
        }
    }

    public int getRotation() {
        if (this.facing == EnumFacing.NORTH) {
            return this.side == HalfBlockSide.LEFT ? 0 : 180;
        }
        if (this.facing == EnumFacing.EAST) {
            return this.side == HalfBlockSide.LEFT ? 270 : 90;
        }
        if (this.facing == EnumFacing.SOUTH) {
            return this.side == HalfBlockSide.LEFT ? 180 : 0;
        }
        return this.side == HalfBlockSide.LEFT ? 90 : 270;
    }

    public float getHeight() {
        return this.height;
    }

    public TextureAtlasSprite getSprite() {
        return this.sprite;
    }

    public int getColour() {
        return this.blockColour;
    }

    public void setPartnerBlock(HalfBlock block) {
        this.partnerBlock = block;
    }

    public HalfBlock getPartnerBlock() {
        return this.partnerBlock;
    }

    public boolean renderNear() {
        if (this.isFluid) {
            if (this.side == HalfBlockSide.LEFT) {
                return this.renderFar();
            }
            IBlockState near = this.world.func_180495_p(this.pos.func_177972_a(this.facing.func_176734_d()));
            return !this.checkStateForFluid(near, this.pos.func_177972_a(this.facing.func_176734_d()));
        }
        return true;
    }

    public boolean renderNearMirrored() {
        if (this.isFluid) {
            if (this.side == HalfBlockSide.RIGHT) {
                return this.renderFarMirrored();
            }
            IBlockState near = this.world.func_180495_p(this.pos.func_177972_a(this.facing.func_176734_d()));
            return !this.checkStateForFluid(near, this.pos.func_177972_a(this.facing.func_176734_d()));
        }
        return true;
    }

    public boolean renderFar() {
        if (this.isFluid) {
            if (this.side == HalfBlockSide.RIGHT) {
                return this.renderNear();
            }
            IBlockState far = this.world.func_180495_p(this.pos.func_177972_a(this.facing));
            return !this.checkStateForFluid(far, this.pos.func_177972_a(this.facing));
        }
        return true;
    }

    public boolean renderFarMirrored() {
        if (this.isFluid) {
            if (this.side == HalfBlockSide.LEFT) {
                return this.renderNearMirrored();
            }
            IBlockState far = this.world.func_180495_p(this.pos.func_177972_a(this.facing));
            return !this.checkStateForFluid(far, this.pos.func_177972_a(this.facing));
        }
        return true;
    }

    public boolean renderTop() {
        if (this.isFluid) {
            IBlockState above = this.world.func_180495_p(this.pos.func_177972_a(EnumFacing.UP));
            return !this.checkStateForFluid(above, this.pos.func_177972_a(EnumFacing.UP));
        }
        return true;
    }

    public boolean renderBottom() {
        return !this.isFluid;
    }

    public boolean renderDivision() {
        if (this.isFluid && this.partnerBlock.isFluid) {
            return false;
        }
        if (((Boolean)this.world.func_180495_p(this.pos).func_177229_b((IProperty)RoadBlockDiagonal.TRANSPARENCY)).booleanValue()) {
            return true;
        }
        return this.height != this.partnerBlock.height || this.partnerBlock.isFluid;
    }

    public boolean checkStateForFluid(IBlockState state, BlockPos pos) {
        HalfBlock hbSide;
        if (state.func_177230_c() instanceof BlockLiquid || state.func_177230_c() instanceof BlockFluidBase) {
            return true;
        }
        return state.func_177230_c() instanceof RoadBlockDiagonal && (hbSide = this.getCardinalHalfBlock(state, pos, (EnumFacing)state.func_177229_b(RoadBlockDiagonal.FACING), HalfBlockSide.getFacingFromDirection(this.side, this.facing))).isFluid();
    }

    public float heightNW() {
        return this.height;
    }

    public float heightNE() {
        return this.height;
    }

    public float heightSE() {
        return this.height;
    }

    public float heightSW() {
        return this.height;
    }

    public boolean isFluid() {
        return this.isFluid;
    }

    public HalfBlock getCardinalHalfBlock(IBlockState state, BlockPos pos, EnumFacing blockFacing, EnumFacing blockSide) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState extendedState = (IExtendedBlockState)state;
            return new HalfBlock(extendedState, HalfBlockSide.getSide(blockFacing, blockSide), pos, this.facing);
        }
        return null;
    }

    public static HalfBlock getHalfBlock(IBlockState state, HalfBlockSide side, BlockPos pos, EnumFacing facing) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState extendedState = (IExtendedBlockState)state;
            return new HalfBlock(extendedState, side, pos, facing);
        }
        return null;
    }

    public static enum HalfBlockSide {
        LEFT,
        RIGHT;


        public static EnumFacing getFacingFromDirection(HalfBlockSide side, EnumFacing blockFacing) {
            if (blockFacing == EnumFacing.NORTH) {
                return side == LEFT ? EnumFacing.WEST : EnumFacing.EAST;
            }
            if (blockFacing == EnumFacing.EAST) {
                return side == LEFT ? EnumFacing.NORTH : EnumFacing.SOUTH;
            }
            if (blockFacing == EnumFacing.SOUTH) {
                return side == LEFT ? EnumFacing.EAST : EnumFacing.WEST;
            }
            if (blockFacing == EnumFacing.WEST) {
                return side == LEFT ? EnumFacing.SOUTH : EnumFacing.NORTH;
            }
            return null;
        }

        public static HalfBlockSide getSide(EnumFacing blockFacing, EnumFacing sideCheck) {
            if (blockFacing == EnumFacing.NORTH && sideCheck == EnumFacing.WEST || blockFacing == EnumFacing.EAST && sideCheck == EnumFacing.NORTH || blockFacing == EnumFacing.SOUTH && sideCheck == EnumFacing.EAST || blockFacing == EnumFacing.WEST && sideCheck == EnumFacing.SOUTH) {
                return LEFT;
            }
            if (blockFacing == EnumFacing.NORTH && sideCheck == EnumFacing.EAST || blockFacing == EnumFacing.EAST && sideCheck == EnumFacing.SOUTH || blockFacing == EnumFacing.SOUTH && sideCheck == EnumFacing.WEST || blockFacing == EnumFacing.WEST && sideCheck == EnumFacing.NORTH) {
                return RIGHT;
            }
            return null;
        }
    }
}

