/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.decorative;

import com.silvaniastudios.roads.blocks.FRBlocks;
import com.silvaniastudios.roads.blocks.decorative.MetalPost;
import com.silvaniastudios.roads.blocks.enums.EnumSimpleRotation;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class StreetLight
extends MetalPost {
    public static final PropertyEnum<EnumSimpleRotation> ROTATION = PropertyEnum.func_177709_a((String)"rotation", EnumSimpleRotation.class);
    private double length;
    private double width;
    private double height;

    public StreetLight(String name, double length, double width, double height) {
        super(name, true, 0.0);
        this.func_149715_a(1.0f);
        this.length = length;
        this.width = width;
        this.height = height;
    }

    @Override
    public void setDefaultState() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(ROTATION, (Comparable)((Object)EnumSimpleRotation.NORTH)));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (facing == EnumFacing.NORTH) {
            return this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)EnumSimpleRotation.NORTH));
        }
        if (facing == EnumFacing.EAST) {
            return this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)EnumSimpleRotation.EAST));
        }
        if (facing == EnumFacing.SOUTH) {
            return this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)EnumSimpleRotation.SOUTH));
        }
        if (facing == EnumFacing.WEST) {
            return this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)EnumSimpleRotation.WEST));
        }
        if (placer.func_174811_aO() == EnumFacing.NORTH) {
            return this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)EnumSimpleRotation.SOUTH));
        }
        if (placer.func_174811_aO() == EnumFacing.EAST) {
            return this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)EnumSimpleRotation.WEST));
        }
        if (placer.func_174811_aO() == EnumFacing.SOUTH) {
            return this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)EnumSimpleRotation.NORTH));
        }
        if (placer.func_174811_aO() == EnumFacing.WEST) {
            return this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)EnumSimpleRotation.EAST));
        }
        return this.func_176223_P();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.placeLightBlockBelow(world, pos, placer);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        this.destroyLightBlockBelow(worldIn, pos);
        super.func_180663_b(worldIn, pos, state);
    }

    public void placeLightBlockBelow(World world, BlockPos pos, EntityLivingBase placer) {
        BlockPos posOffset = pos.func_177972_a(EnumFacing.DOWN);
        Block block = world.func_180495_p(posOffset).func_177230_c();
        for (int count = 0; block == Blocks.field_150350_a && count < 15; ++count) {
            Block targetBlock;
            posOffset = posOffset.func_177972_a(EnumFacing.DOWN);
            block = world.func_180495_p(posOffset).func_177230_c();
            if (block == Blocks.field_150350_a || (targetBlock = world.func_180495_p(posOffset.func_177972_a(EnumFacing.UP)).func_177230_c()) != Blocks.field_150350_a) continue;
            world.func_180501_a(posOffset.func_177972_a(EnumFacing.UP), FRBlocks.fake_light_source.func_180642_a(world, posOffset, EnumFacing.UP, 0.0f, 0.0f, 0.0f, 0, placer), 3);
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void destroyLightBlockBelow(World world, BlockPos pos) {
        BlockPos posOffset = pos.func_177972_a(EnumFacing.DOWN);
        Block block = world.func_180495_p(posOffset).func_177230_c();
        for (int count = 0; block != FRBlocks.fake_light_source && count < 15; ++count) {
            posOffset = posOffset.func_177972_a(EnumFacing.DOWN);
            block = world.func_180495_p(posOffset).func_177230_c();
            if (block != FRBlocks.fake_light_source) continue;
            world.func_175698_g(posOffset);
        }
    }

    @Override
    public AxisAlignedBB getBoxFromState(IBlockState state, IBlockAccess world, BlockPos pos) {
        int meta = this.func_176201_c(state);
        double v = 0.0625;
        if (meta == 0) {
            return new AxisAlignedBB((8.0 - this.width / 2.0) * v, 7.0 * v, 16.0 * v - this.length * v, (8.0 + this.width / 2.0) * v, (7.0 + this.height) * v, 16.0 * v);
        }
        if (meta == 1) {
            return new AxisAlignedBB(0.0, 7.0 * v, (8.0 - this.width / 2.0) * v, this.length * v, (7.0 + this.height) * v, (8.0 + this.width / 2.0) * v);
        }
        if (meta == 2) {
            return new AxisAlignedBB((8.0 - this.width / 2.0) * v, 7.0 * v, 0.0, (8.0 + this.width / 2.0) * v, (7.0 + this.height) * v, this.length * v);
        }
        if (meta == 3) {
            return new AxisAlignedBB(16.0 * v - this.length * v, 7.0 * v, (8.0 - this.width / 2.0) * v, 16.0 * v, (7.0 + this.height) * v, (8.0 + this.width / 2.0) * v);
        }
        return new AxisAlignedBB(0.0, 0.4375, 0.0, 1.0, 1.0, 1.0);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        if (meta == 0) {
            this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)EnumSimpleRotation.NORTH));
        }
        if (meta == 1) {
            this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)EnumSimpleRotation.EAST));
        }
        if (meta == 2) {
            this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)EnumSimpleRotation.SOUTH));
        }
        if (meta == 3) {
            this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)EnumSimpleRotation.WEST));
        }
        return this.func_176223_P().func_177226_a(ROTATION, (Comparable)((Object)EnumSimpleRotation.byMetadata(meta)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumSimpleRotation)((Object)state.func_177229_b(ROTATION))).getMetadata();
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }
}

